(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    690670,      11997]
NotebookOptionsPosition[    684810,      11831]
NotebookOutlinePosition[    685539,      11855]
CellTagsIndexPosition[    685496,      11852]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Geometric Optics application - short guide", "Title"],

Cell["Introduction", "Title"],

Cell["\<\
GeometricOptics is a collection of packages related to optical system\
\[CloseCurlyQuote]s design as illustrated in the book \
\[OpenCurlyDoubleQuote]Geometric Optics\[CloseCurlyDoubleQuote] by Antonio \
Romano, Roberto Cavaliere.
The whole application is composed of a main package called GeometricOptics \
and additional packages, combined with different chapters of the book.
Here is a full list of packages (in alphabetical order):\
\>", "Text"],

Cell["\<\
BakerSchmidtCameraCP (Baker-Schmidt camera with conic primary)\
\>", "Item"],

Cell["\<\
BakerSchmidtCameraSM (Baker-Schmidt camera with spherical mirrors)\
\>", "Item"],

Cell["BuchroederCamera (Buchroeder Camera)", "Item"],

Cell["CassegrainCombination (Cassegrain combinations)", "Item"],

Cell["Fraunhofer (Fraunhofer\[CloseCurlyQuote]s doublet)", "Item"],

Cell["HoughtonCamera (Houghton Camera)", "Item"],

Cell["HoughtonCassegrain (Houghton-Cassegrain)", "Item"],

Cell["\<\
HoughtonCassegrainC (Houghton-Cassegrain with corrector at the prime focus)\
\>", "Item"],

Cell["KlevtsovTelescope (Klevtsov Combination)", "Item"],

Cell["MaksutovCamera (Maksutov Camera)", "Item"],

Cell["MaksutovCassegrain (Maksutov-Cassegrain Telescope)", "Item"],

Cell["SchmidtCamera (Schmidt Camera)", "Item"],

Cell["\<\
SchmidtCassegrainCAfter (Schmidt-Cassegrain Telescope with a corrector after \
the Cassegrain combination)\
\>", "Item"],

Cell["\<\
SchmidtCassegrainCBefore (Schmidt-Cassegrain Telescope with a corrector in \
front of the Cassegrain combination)\
\>", "Item"],

Cell["\<\
SchmidtCassegrainCBeforeSM (Schmidt-Cassegrain Telescope with a corrector \
after Cassegrain combination and spherical mirrors)\
\>", "Item"],

Cell["Triplet (Triplet)", "Item"],

Cell["WrightCamera (Wright Camera)", "Item"],

Cell["\<\
The main package defines the function TotalAberrations, an auxilliary \
function called by all packages, which can also be used as stand alone \
function to calculate aberrations. See examples provided in the notebook \
TotalAberration in \\GeometricOptics\\TotalAberrations\t\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Installation", "Title"],

Cell[TextData[{
 "To run the application you need ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 11 (or later) installed on your computer (it should also work on ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 10.x as well)."
}], "Text"],

Cell[CellGroupData[{

Cell["Using the installer", "Chapter"],

Cell["\<\
The package has an installer notebook. It can be used either if you are \
installing the software the first time or when you already have some chapters \
and are adding others to your Geometric Optics applications.
Open the file \[OpenCurlyDoubleQuote]GeometricOptics installer.nb\
\[CloseCurlyDoubleQuote]. In order to install the package you need to keep \
the zipped archive as downloaded.\
\>", "Text"],

Cell[TextData[{
 "Open ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and then open the installer. It shows a dialog window like the following"
}], "Text"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnXd8FeeZ7w9pG2/WSTZlN/ePu3fvJrdknWQDDjam25jeqxBFVAkQvRfR
JYFQ70JCQoBASIBophhEsbHBxsZgMGBi8CbreO913BPbuZ/YTuY+77wzc955
p5w5kpA0o9/388SZ886cmfecM/PV80x5+e9T549I+EooFFr8TfrPiCnLH1+0
aMrKkd+lF6PnLZ41Y1789P7zlsTPiF/UaepXqXFYu1Coiv7Hph/4+oN/87W/
/ebXv/XAN/6O4m//5sFvffPbD/7tdym+/a2/p/jug9//+2//gOJ73/khwo/B
fz76HfkPyn9c+pXpt+Y/Ov36tA/w+MZXH0AgAhZkOfrvs2cvKgAAEET2VO7n
uqPp7u0HThs7d8uG3PSNeRkpBVmphdmbi3LSinO3lOSlb83PKKUoyCwrzNpm
GzTLGvkZkSMvvVSOLdbY6hS5aSVi5AiRvbnYJjYV8chK1SIzpVCKjGQ1Nhbw
SN+YT7FlY54YaRty09ZrsXldDsWmtdks1mSnrs6iSFFjY1IGi1XpPDas2MJj
/fK0dcvS1i7bTLFm6abVi1N5JC1OSVq4kWLVgo0r5rNYNne9GuuWzVm3dPba
JbPXLE5cvWgWi4UzkxbMSFqQsGpB/Mr501fMm75i7vTls6ctYzF16ewpSxMn
L0mctHhm3KKE8Qvixy+YFjtvSszcuFGJE0fMHD8sPmbQtNEDpozqN2lE74lD
eo0b/HjswB5j+ncb06/LqL5dRvbpPLL3YyN6PTqM4olHhrLoOOTxX2nR8+HB
LDoM6tF+II/uvxxA0U2Nrubo8m/9KTr/oh/FYz/vKwZv5AtI7+Kr4qs1tkJb
5Js2ekK94t3jXX2y03Dqdh8enUfSB+nXdRRF/66jB3QbM6A7i4E9Ygb1HDvo
8djBT4yjGNprPMWwJycM7z1hRJ+JI/vGjewXN7L/JAr6fsYMmBozcOrYQdNi
B0+PHRI/bmj8+GEJFBNGzJg4cmbcyFmTRiVOGp04efRsiqkxcymmx86LH6fG
hAUJExbyoF9h1qTFFPSj0E8zZ+oyHvOmL9cifgUF+zUTVi2cwWLRzCT+Qy9O
pB99zRL267NYOmct2x94zGOxfN56ihXzNmih7jkrF8ixamEyj6RFKTyMHU+M
NUs2GbF2qSnWLdvsHGlyLJdjPe35kWLDSpswjqBog36pR3/6JPnNEB39iBnJ
+dxvJDeutaLsbSW5FVvztpfmV5YV7NhWuHNb0S6boHZLlHmI0oIdcuRLUekS
W/OEyA1HSe522yjOqeBRlF3OQzZ2pinCxs4sZaHanrSfu0WPNBaaWjcX56gi
NfuzgAe3pebMDXmGITetzUklN6qRsjqTRVJm8qrMjSszNqxIV3/6NMOKpMQ1
S1JXUyxWd9SFLFZqStxAu/oyHnPX0bFASlxCBwgdKTOT5iesnDNt+eypy2ZN
WpIwYQH9RZsyZnbciFnjhyaMHUy6mzy8z8ShdNT3HDuge0z/bqNJEU8+Npyk
QdFgxYl+syrOqjtb40WlO+46Q3ei8Vx0RzHEVneq60b1n2zojrlO0N2E4Ta6
mzJmDrlu2th5mu7GzzdcN2PiIq47yXWS7ubHrzR0x1wXUXeC68K6m7/RVnce
XeeiO1fXWXTXClxHP6soukxVcXQU637bXqqarby4avvW3ZWl1Tu37d1VXlNV
USsFNUqxc5vH2CtHWRSxo7TaiEohtm/dYxMlu3lUFGtBn0uKbUV6FO5Sw6zr
AhbMvbqNya6ySLMrKIqyTP4syCgTg1JWLkkx58xieiykUPNJLY1kqaOuRNWK
2TxpTF2jZozMh5QrstiwMn39yi0sjD2KrKjtpamrFqWsWECZ4To6TBbMWMWy
vilLZ0xcOC127uTRlN3NGDt4+uj+k0f0iRvSazwd9SS6vl1HkRx6dRrWi1lu
qJPiuOWcFOeUxbH4WR8n3RnvtdWduGmPuhOzOyPBs83uDN1x1znpjmd34dRu
eAK5zkl3Wmpn1p2R2omuC+tOTe0M3Ymu47ozREf/FV0np3YOrmt8atcMrrPV
XYNdJ4qOZ3FccZS8lRfvIj/sKKsmce2u3Fe980DNrrraqoP7dh8yonb3QWvU
VHmLXRGjzin27jwgRvUOISptgip0Hru379OiQo4qHuW1PEzq3sbCsPGOMhai
WitVkVaUmBWq5brhUA2pJaIletpZnEtu1NNLlkNqYmTZIymRssf0rUZVbpTe
LGNMLsxkJXZBejJliXnpG8iKuRRp68KlNE8Uk5MyyYS0B1IeSPs/1b904NCh
lDh5MdWzU2PmxI2cGTs0ng5kyuuohh3Yc2y/rpTUjej1iFq0dhzK/eY9i4ug
ODEapDs5u1ON5113RnbHEjxLdicWs2HdqcUsdx2FVsnqumOpna47sZLluqPU
Tsvu9ErWSO2sups7bZnoOq47sYzlYbiOh+/K2GhdtzBxxZD+I3t2fZLi8W69
3WPogJGLZq90Eh0lcsU55XQYbivaSSkcHdGUrVXv2E9i2bfn8IG9Rw7WPHVo
37HD+4/zoOmGxcHaiPGUW9SEo26vKQ7sPWoT1Ud47N+jBX0cOXarUXWIojYc
B40w9LtXDZNadxzYs30/BVdoFQ+W6AqxrYbrcYeYc2pJZlUFsyILkmG4qOdJ
I7Pi9pI8Krr1ulvLGFnSmM9qak2J+elqTS0qkVmR5YoZKQWUGW5em0NJIO1j
VPlSnUuFLR1EiVOWUiU7JWYOlWBjh0ynvGXYk+MHPz62f7cxrHp9dBhL58gh
Dw9ugkJV9NtDnnQXXTFrTvCY7gTj8TK8t7dzd2Ixa83u5BN3ajErV7KjE3lw
14VP3I2fb2R3ou6kSpbpzuw6a2oX0XVSatckrmupMrbPEwOvlGV/duPlP9++
+sWdV//yxvW/8rh7g09QC7XTXFqGluzba6CT6Jjl1ESusnQPpTF7uOJ2HyLF
Hao9duTAiaN1J48devrYoVMUTx162iYORo6jdRHjpFtQN/Q4IsTh/bZxXNCy
HrXHxAjblZszHEd5CMJksX/PYTFYWiu4Uc1Uec6phWZCPaXU8kZe9ZfXVJXz
XLHGcKCWH6pRwR2oaVBNC43ymTuQn6VkmaHp3CPXYIF+jpEcSNLLTC2kfC9l
ddaGFVtoF6Xde+mcdfMTyHXsrN3kMbPpUI0ZOIUVsE+MG9A9pq8qul5MdFou
12SKE6PZdSedu/NSzFqvU9BfBArb6xSmSna0YyVrZHfkOtsTd+Q6rjvRdZ5S
u8adsmuFZSyJjhK5jy8/80FV7qe1RX+uK/3ycPlf1PjrkQo+QS3UTnNpGVqS
8jon0am5HCtXKZejWnWvmsjV7T16qGx91xBnRuGR+qefOnPSGkc9xYmj9aY4
EkXsWds9FOq+ccfpE0dYHD8sxKHTx3NmhsLMLDx0mguZOdnVujuTuoVC3dZV
hF16pO6EFvvDQdo0VFm5kr6PrqtLw+mlmk8erdOzx/166OmirkE9Idyrm7C6
MnNCKDRhA2WDGeND7SZsUFNBftrTqJcNB25lqWDF1t0sVAdWFOsCVFPB0oLk
0aF2Y5bvCF+mUavjouxtlPVRmpeZUrhl5rDQv8YvXZlOuy4dBXSkzJ2+fFbc
Iso36MCkA5Yldb3GD+rBRNf70eEkup4dmEMiVqlRKa7Tv/ZusO4aUM96151t
MWuT3TlclhVP3PHsjleyXHdyajdhAdedeJFCrGQN10lXKJjuBNfxs3aG65ju
5t331K7hrmtQGUui++jSmQ+2p322O+vPe/O+3FfwFzX+ur+QT1ALtdNcWoaW
dBFdWcEOOnx2lFWzinXnAarX6JitXEkeCE3PfvrY4VMn8ma1I9es33/q+DlT
HIscTx87K8dTDpGfGArNKpbbz4gh+bN6XQ/qZEKe+JKUyPRo8qERlald6XNU
kgzDPjRlqrIPVQEeMELNFfexUNWnluS84jZqamY/ngrmTQqFJm02auRD3Ht6
LZw9MRSamFy3d0fWhFC7ickHxBOJ2rWebULWx4JffNlTqde/4RODRaljQu1i
VqreY7nfjjL1QnZx7nZK8PLStyT8PPSL/sN/3mdov1C7PpM20R6+JHGNerJu
Sfy4+XQkjh8aP2bAFFa99hzbv+uo3lS6/mpIjw4Du7cfGN2JONcsjizHI6rs
7n6cvgu7LpLu3LM76bKsdAuKprtRDpWscOLO9v4T6aydbWrHL8iaXGdJ7TTd
tcpTdhF1x0T33MkPStZ/VpH65x1pX+5K/wtFVcZfqzLovzRNLdROc2kZWtJF
dNsKtVNzdIjtVYvWupq8ae1C07JO0rF//Mjpk0frTx07e/r4OTFk6dlGZBOe
DUcBE12J0OKkRF10pQksJ9snqK++aFooNK3UyAap86ZQRbehkkmPBC6FXa0t
5HsHxDRPrYst5x7rRNFVc9EdEardw3qRS6ldFoluQvKB6p2ZquhMF03U8pbF
zvKaneXaVWlddGKFy6+DUJGbGkOiW1VVrl4yNq4UU2pH9WxeBhWwm6f9jP4m
tOs/PZNXr5QJ0FFDhxWJbuqYORNY9Tp1ZJ+JTHRdRqnn6IZ07zComy666BTn
4DdrOBqvWXQnnrszdOd0352L7vh1Ckl3RiUrXqdwuiYbIbUz32un6c5Damfr
On/decJEd/6pD3JXfFa0+s+l61JSskeOSaAQJ6id5tIytKSb6Ng1CPXsXCU7
O0eH5MEt09uF4vMPsnTOsFz9yWfUqGDpHSehgjeWzmgXrh6L1MWK5rQLJc6M
5+09U3afr9nYU51O3Hr8/GmKwtntwgXnOfFl9w0Hajb0CHVNnNlVXb6QBJhY
ooqxZn0PfalZJVWbu4d6pFSZlLiXLUBp4RnVeLMSjJ5S1rdzUzejlyTD3Jls
y6oAd7PqWO8LOTBnhvaqc8outQTWziJm0foScim1y4wPheKnTdKWmprBc7yC
KVpD16St+ZONbXVau606d5LxMjQlnaV2OXGhUFwqSY+M1y4uWb26kWy8qd14
Kma316r+ihtHDR1X5Gt315QsejjUcfSEjnzBh5flsOxuM1tw1Hjj3euKdlFt
W5rPkrqCzG0bpnQI/TwxiarX0NCZy9L4abqFJDo1o5s6ZvaE4TPU03QT6XDu
330MGeBxXXTRVamWQtVLOGZ3UZ6+c78dJdo7jU26M1+WNYpZq+68nLjjqZ27
7ozULuw6VXeG67SLFNGmdn6784SJrv7QB1vmf5a95M95y8hs/JEHcYLaaS4t
Q0u6ik64DFF1cH/1ke0ru4Ye27BTTed4eci1dubpg6ndqTisM4xHWqtNfjwU
ml160vBbz9Q9NKGKK6G8/mRdKrdIt7TaE3Wp3ZjH6vek9aDFdp+vP3G+niku
sVSdCKkTJFUmOtV4LHtURbdVa9SMx6LAEKCQAebP4qIrnq52OZ8VvOr0rKKj
3HXdk3fWk71P5qmiO1qvWk4zHsv0tPL2lPVcHxddHiV4WapBJxdSdscU9tiG
yn2713QKdV5Zxa9uqHldHmlrctpR7cSdds03l/zWaWll7W5VdCk8tSPR1VXn
rno01HlZrprXbZgUajdpUwUTnaot7azdDnaLCxMdrWNhxp7K9KUdQ+1iV+/e
vnWTuuCE9ez0HXtTu1Gp9LNSaleiii5vy9as1KIt6/OSkzLXcdHNXrtQz+im
jFavRwyaOrxvHB3LA3rE9OkyUhfdgEZWqd6jMfVsA56t8H4viqfszvV5CqOS
5bozUjsKzXX6LSjcdRTcdVx3kutE3dneV+wxtWttZayT6H53YPvt2cP+ff7I
txaN5omc8YQXz+ionebSMrRk1KKjjM6oW4+fYzkb5W/VW4yMSsu+NlYI6qPg
Jjygio6Md77+5PlayuWY5ZjWShMoVSyv1bI7A1V6qui2qnWxmtGl1fAyWRPd
gRQmoAOnTKLTMrpwUkei67ppL5fb9FLttB7zWw/mt52phuhOcNEdqdnQJdR1
bY1mOR6VtKkZBaLieBmri45ndLm8hs2g6ek57Epu1epOoclb1Ou27AoFE51a
ujLFZUwIf9pOS7bXVGXHiefoNu4vWviY+Tt5bEl2bQpL1LboiuN38RUvfDj0
yNwitYAtXEDZ3ZyiimISXbuxq7QLtZmJj4Q6LMksVDO6nIqCjLLctK2ZqYVp
63OTV2Ww0nXBRk10+jm6ccMSxuiio4yud+cRPX81mKdzzaC4ptJdA242tr1a
4TG7M3Tnfp1CugXFvZLlurO9IBt2nfkxCjG1s3fdXNl1Lqlda7vzhER3vXjz
0Z7/8nSvn5zp9ZNzT/4Pw3XcctRC7TSXlqEloypd67au60LlXfZJymd46bo1
wRCdmrCdfMZsNk10p/WcTS1FE7ey9Ox8zYaeqrXYNFtP/Da1ZXON+aTfaavo
wkKbVXJsvyq6/UL+VsbO0a3fL16z4OfoSG7GhC469SLFjlQ+wbTGS9fDmuj0
SxJqkNyy1Zytc/LOAyePqpchWGh+43KLz1GvRBxKZ0rNUrO4AzV5avHZJamY
/JbLL0bU7j5UuqQzVaxb2P3S21c8Euq0uGLvTvWqK1WslaRAdtW1YEGnUMeV
hcLzJlSoJo8JtRuTZn70o2hBB1Vu7PJrwXyaTiwoL1KNuEq7GS9jFoluUWbB
DvXCazm7yWRTUcbG/E1rsjauTKfdkt1Nl7iaDhY6lKbFzpukim70wCnDek+g
Q7hv11F04Pd4eBCvWJu2Sm2g8RpRz3rN7iLpTjx35/2yrPUGY+lhCvkihXB3
sfXWYlNqN3250/0nVt010nUtWMaS6G6WpJ18/McktGd7/0/bjI7aaS4tQ0t6
vxhRu/vggb1Hcya1U+++eJrynBNH64vjmaBOUVrVLUSO2itccWDWonypikuJ
/NYjeRefME6sMa3tVWvMElrP9LJT7PQaWWufeDFCvOrKTrXRW/ilh7xZvPBU
i2hKzLTrDhTV61hVHJ+rXXconKbWuztOh6cr2UWHgqnknpSqw6fUVE0rS1WV
JeQffHrXan6fiX7p4YB+3WHbRqbAbeyiA49DGcxp2bXH6raocuMXHTYzpWZU
H9GvOFSufJRytkrK2dh11RR2M8nmcaHQuMzqHSQ/qk9Djy4sU+8qCY1fV1tV
nj4u1G7cur07s5Y/Ego9Mq94h3q5gV9xWD8q1G70Jn5P3bpRrCAtL8yf1z70
q8R89XJD7lyanpVXmp88mj5u+4Xp7N6SDTT98IwczXIZpTmbizOTC7asz01d
nbVheVrSomTayRfOTJozbTkdSlNj58aNmsXvGR7Sazw7QffYcErnuncYKIvO
6Y64+2A5++wu0tUKj/VsU+nOeu7O+rSs0/MU0ok7p+dkbS9SNNx1zrprtXee
kOjubMs41/enFwc89OKgn9meo6N2mkvL0JJebi+hLKJaq14PH6x9qnJVN6GS
UvVFsqpK625pLI4PX4xIKFDvIclPbBe2FoluU7U6XTydiU5rNOiaWs3ysX3J
6n173dbtY07rsqma52O66LQ8TYOqTvUeklzzfXT6nSTswkDn7sZ9gAX62bZ8
fsFgSjEXXZ5ak/I8TCU+dxuleBpT0oUbjGueOmj4LY3JLZPfL7eZNDolg/z2
iP62cdn8ZrmSRZ3Zy45JRZVlyzqGe/nI/NJd27Yw+a2t2VGWFkuiW8PuG8mZ
82h4oYeXZJHcRobajUzh98utHRFqNyK5lMttZi67ZS4/Z84vudM2jAqFOvxS
20a7YeuLstktxGrRWpKVWpi+MX/z2uyNat26gupWdsPwqtlTl8bzG4aHz+B1
68CeYymd69VpmF63qmfnmjGLa5LsLtp61ubWu0iXKlyyO9sTd6bsbojp2THx
OVnuOqvubJ8aC5exgu7EwU/EoQAk3TWP65rkzhMS3Zs7818c9ei1mMdei+1s
e9WV2mkuLUNL0vLis7E2NwyX6EndzgP8sYiDtccO7z9xtO5pquZ4XmcfkW/6
Pe0S9je8HZbvcxMuDRhhuttNCvVKQOER82MU2o1wpnvhjh8UboQz3x9yRHqI
jLRWy57zZaHfJVInPnW7p1K/Hc54CEItRfk4BtooBHq2pt0cUqIPLMDvDCnY
WVqwk48eoD/+wJ+NrdAegsgu50/IFuoDsGjPQehDBxjPheWnb6VcTrPcupzk
pAzac5IWpyybt35R4mqezlHdytO5EX3jhvTiZ+dGsrqVi+4XfTsbiVzjUrhH
f/qkNVrV6Tv3e1Ek3UkPkdlep3A6ceelkg27TrhIwV0nPjXmdNbOXXf2rnO4
QtHid56QuP6jtuz6tD53EgbcmznwN4mDfjObxW9naxPUQu00l5ahJbnoDNeZ
HwGr2Ko9HLFbPVNHrqurrTq0v/pIHXvK9Th/Cqz1PNjl9FTXIeGprix2UTPf
/qku/kiXdjFUe55LfKTLeJ7LeKTL8Xku/dl/08NcNk9ysZs9+GNc/Eku7TGu
3O1b9SGk9Ae4ykV32QwPtYWPDVVMwZ/0zzKCDRIVHh5KHSGKDYGSuiaL5XLL
NpPlls/fsEg9O6dZbnRi7ND4kf0nD31yfDide3hw9/YDupIcuOgaXaXaWq5h
rougu4aevot4L4qX7M76SIWku4h33EnXZN1TO0N3bq6zjPLkUsa2lgcozKLr
0eXJ/zy869eLYn67dPzbKyb831UT30mKo/i9+l8KaqF2mkvL0JKG6LjrRNGp
Q5eUb83bThkFr2HpsN1dud/QHcmB7BHWSzjMj+1btOMS4hP65kdNtYeqpHB5
VF94Zv+I+pA+s5Z6Ciwn/BCWeewUlolxie0Qk7ED4UFOtpvGMzEGMKm0PJsv
5GPagwn6aE6V2mhOOdtZDpZVzgdxKtCHKlUNpo0saoxrpw/cpCpLDTZ2U3I+
hTpWSb4++Gd4ECdt/M+1PLI3syFAsyjIb5TFUfJvKG7x7DXzElZSxZowceGU
sXPpyKJcjiynXoMY26/b6N6dhqv3CbPHvrqQHH7Wl6KRhaqL5RrsugboziXB
s16taKrsThwLxfEGY4dhAWweHNN1Z03tJN15yevcU7vWU8aS6H5/cv9v1s/8
P6lz3kub92H6AoqPMhZ+nLGQ/stfUjvNpWVoSVF0FKLoKDegnIGOweLcCjbM
ZuEuKqnUYejYGHSUwFSTEHY12VBL0mhL0nggDRttyRhqSR4iTxhnyW2QpRLj
WapdWvZlslZl2Fo8AeP1Y1Z4eCVuLTaw0hZ9FJFN2sBKbBDO5MJ086hK4ujE
xtibyUlqrNLGJd6wUhuXmGRl/O5saGJ1twnvUbSD0V6nRtKiZB6r1FixYCP5
jd0bPDNpnvoU/ww9kRun3jg3st8kyuWY5bqO4pbr8fAgOt67/Lxfl59rlmvw
ibWIimu87qKtZyPebGx7cTbipQr7m+7sLstKuhOH9LTqzuVJiqhSO9F1zVDG
Nu2dJ32eGPjqgao/vnj2Ty8/8+dXLnxx7bkvzUEt1E5zaRlasm+vQU6iy0wt
oCxCHTi9lA5byu5K8ipLC9iQwurYm3vICaSIlh0202XkTGHMTPMox7xOLDAN
mGnylTr2EYXtaJmau9Qx2/nwR3qFqA+SmSwPkqmLK4uPkCkPj2kZGHP1ktSk
xam0w6xauHGVNoj6Bj5iMAvaA9mIweuWzFm7JDxusBaL1AGE+V9tFgks+L49
Xw820ubUZbMmL6EUbvq4+VNi5kwcNWscG0p9Kkvk+kwc9EQsHZV9Oo94shN7
5qtHB2a5rr/o30jLRaW45tddVNldxGLW5aY7p4E9+XUK+VFZy93F4kWKsO70
1M5p1GL34dkbWcY2/50ncxOW9n58AOV1PPjAdE7R5/GB82YsE4ezE0WXpv9r
EZmpRXQ406Gdl1FKFVYh5S05FSWqHMgS9kOgy+Ofuw2Bbhr/3MMQ6JHHP8+S
Rz43qkLj7Fb4BJcx+LkwiKU+8jk7o5WRHB7z3KgK+YDnKWuyjNHON67MCI92
Lgx1vtoY6nwhiSvZNMi5OsI5GxiWj3A+a/VC9d99oN1vPvvjy4KkxGLasjm0
06q3xFMCRo5iQX+74xbNnKjFjIkLZ9Cf9fELeMSPm89juhCUtqn/TsQcOlJI
buOHz4gdGh8zeNqoAZNH9I3jWRwdiXRsqonc0J4dBndvP7Dbv2m5XBNecWhO
47ndjhLl4xXR6s6a3TnpznriTrwma/svU4hPUkhjAtiOWmx9ZMyT61p9GduA
oTtF0aWuzUpdm03ZyOs336C4c4vi7q9vU9z79ev33tDizTfuyPHrO/fkeL1B
cfuul1A7Fjlev/lra9x+zRS3eNy4Q3GTx/XXjXiNxe3XXtXj2i2KGxRXb16n
eIXHa6/qcY3iCourL99Q4/orFC/xePWVy1pcefEaxcsvUFzV45WX9Lh8SY+L
LF68eIXF81deMMXLLzxnjgs8XjLikhAXKZ598eIzLz5Pcf6F586/cOHcpQtn
Lz575uIzZ55/pv65c6efO3v6wtlTF848/awe4t3gnkN97KXpowE9sYsz7hH+
7CzOmuICi1MXzolxmuI5I85T1LN4pv55Fmd4XHz2rBb0hbOvXQv2K1A8z38U
CvqBnr3M4sLlSyzYD6f9uM+/TDsA3xMus1D3jUuvvERh7EK0R6n71ZXLFOGd
jYW6B17loe6Z1yiuGBHegcW4znfySHGDHxGRInwQRRXX5RAPTy9huE4U3cak
jOQkSleyaPpb3/rWgw8++J3vfOe73/3u9773ve9///s/+MEPfvjDH/7DP/zD
PwK/Qb8a/Xb0C9LvSL8m/ab0y9LvS7/yAw888M1vfvMb3/jG17/+9a997Wtf
/epXv/KVr7TTCQHgW8hjRl4nik5spMX+CAAA/iQq0X0MAAB+g9z14x//mP7r
UXTHAADAV3z6/75sgOjoXQgEAuGLaIzoFAAA8AMQHQAg8EB0AIDA411065an
KRAdAMCHSKIzHqBQBNEZz1YoEB0AwIdYRWc4DaIDAAQDiA4AEHiiEN0yiA4A
4Etk0S1zEN0yiA4A4FdsRLfMIrplEB0AwMfYi24ZRCdxN7ezONBL59y7Ld0j
RTmREEo44TKTcJ7v9q6GfEqhMw3btFNnGrUe16/IuhWvW7wPH7aZ8Wm3Gw5E
FxlJcjotu5c0/Z5q/zE9ya51HjbeehW16Frnh42SQHyIaPAsOjaIsdIWRacf
/+GdQm8RHCBKQtp7xFnhd2g7Wq4+k73prvjCbc1mJYXf2jkhweiZtCe7dNDp
Y+rpndZpvkDCiXDSxxe1dsbbpk3vs+2SuB6nrTutytorKV01fgpn0dksH/HD
Ovzc7v2XfwWHxez7H2HNDt8+RKeNyq4go+NoCjHnNawxvJOY6z2bo8iEzUFn
RVu5w5qdRCcuZLWEzfojfExTq13Cx+a4H/tOm7Z8MpvM0X09zl+SW6+sW3QS
XVSrdfy99Dku/bd+4S79tLa7rdl5z4TobDK69cvTeChtUHQR9whZEfpfWGNS
1p76UtsFxcX4C2EZlzXL/bLmY8J8babtGyN8TOtazEeKSybkuml7r7p89eat
C1+Sy6qcfzp3uVnfYWMz5w9r93O79N+E25fc6G9G3H/auuhEp0F0DGmPMP2N
FMxk+5fTsjeFdzXHQ0fYO13WbC868cgR5quTUUjFvtmkWWmTjse+46alz+ax
dDU7xD7VsXW97Xa9iM66fIQPa/9zu/VfxO1LduiP85rd9h+IzkZ0/F9J3tA2
Ry+x249Me1pTic5UiTS96CLs1F5L14aIzv2koPS5BOzO0YmzpNNU7l+RTYXn
KjrH5RsjOof+y1+K3Zfs2B/nNUN0ApLoRKdBdCo2lx7c/lbbvNW5dHUXnWt9
F4XozPWjw1o9XoxoVOnq9IEip5NeReGYn5k2beqV/Tucl29M6epRdDZfsnN/
nNfstv9AdDai27gynYfSFkXneHuJyylfeU+1vsuL6Dyu2f6cV5QXIxw/pmPa
5NwZD5t2zpcEvIkuUuqlNXj6JSzpWcTV2p2DsHtTdKIz4ZieRf4T4Lz/tHXR
iU6TRNdWMzoN8z5jfy7fvC9puN5eEkF0bms21hsubJxEJ63H5XSd9eqtNEu4
jcGxM942bdqUbZcaVrrabcJ8JoBeCatzPEfnsHyEDxvh9hLb/nv7kh36E2HN
DvtPWxcd2cwquuRVGW06owMM+fQRuA/gS75f2GZ0ZDbFJLp0HgpE13bBMdgM
4Eu+X0iiE51miC4lKYOC2w+ia6vgGGwG8CXfLyyiy+BaU0TRrc5MTmKhQHQA
AB8ii04VGplNEUSXuiaLhwLRAQB8iCQ60WmG6DatyeahQHQAAB8iiU50miG6
zetyNq3NplAgOgCAD5FFpwqNzKYIoktbl8tDgegAAD5EEp3otLDo1ufxUCA6
AIAPkUUnOM0Q3ZaNeTwUiA4A4EMk0YlOM0SXkZzPQ4HoAAA+RBKd6DRDdJmp
hRQZKQUKRAcA8CGy6FIKuNYUQXTZm4qzNhVRKBAdAMCHSKLjQiOzKYLocjYX
81AgOgCAD5FEJzrNEF3eltLctK0UCkQHAPAhkui40Mhsiii69FIeCkQHAPAh
kuhEpxmiK8jcVpBZlp9RpkB0AAAfIomObEZOI7MpguiKsssLs7ZRKBAdAMCH
SKLjQiOzKYLoinMqeCgQHQDAh0iiE51miK40bwcPBaIDAPgQSXSi0wzRlRXs
5KFAdAAAHyKJTnSaIbqK4qptRSwUiA4A4EMk0XGhlRczpxmi2751D4uS3QpE
BwDwIZLoyGZca4ogup1le3koEB0AwIdIohOdZoiuqryWYld5jQLRAQB8iCQ6
shnXmiKIbnfF/qqKfRQKRAcA8CGS6LjQyGyKILrqnQd4KBAdAMCHSKITnWaI
rmZXHQ8FovM7JxJCGk7/SjIt0Tn3bvP2qrmx+4zs344O/Advu0iiE51miG7/
niNqHFYgOl/DjmXdb3dzc+1NF5XofGpFn3YbNBxJdGQzrjVFEN2BvUd5KBCd
r/F0fEN0IIBIohOdZoju8P7jh/Ydo1AgOn/DClf5CGdpnljMChKQZ0lN4TLY
XAdb3hZuMBYUVWNMs4mEhM76Ui7rketuS0Xuvip1iye0Nr0fvBti1it0zXnT
wBdIouNCI7MpguieqjtJcbTupALR+R7tiLURzokEdcqkHfMs62ksu9SI2kwy
YBISTGVZuWmLJsk6bkvrjxXvqwoJC5oNL/Rfn/SyadCqkUR3VHXaU6rTDNEd
P1J//MhpCgWiCwaq7dghLORauv70g9o6y5zsqDid1RdaLSmSrA5btVq3ZdNV
c0c0PKwqwtYN0+lSc9808AOS6LjQyGyKILqnj53loUB0QUE7+l0kYK8aD6Iz
lg27tKlE56CY8CyaarzotLUY63LbNPAJkuhEpxmiO338HA8FovM1J3L1o9uo
5qxn7WyrP+ld1oVt0EUhla7hk2bh02k29ax9vWm/MdOZNI+riqRZdobPkJvz
poFPkESnCu08hSKI7uypC2dPPUuhQHT+xu7ygViXiaWrzSzTGowTW3I1Z71V
L7wewRbGYgkJNqqxXZFNf8wbYHbysqpIogvX9vIWULr6FEl0XGhkNkUQ3fkz
z7Oof16B6AAAPkQSHdmMnPbMmYuKILoL5y6xOHtJgegAAD5EEh3ZjGtNEUR3
6cJLalxWIDoAgA+RREc241pTBNG98PzLLzzHQoHoAAA+RBIdFxqZTRFE99Kl
qzwUiA4A4EMk0YlOM0T3yuVrFFdevKZAdAAAHyKJjmzGtaYIort25bVrV25Q
KBAdAMCHSKLjQiOzKYLoXr1689VXXqNQIDoAgA+RRMeFRmZTBNHduHbrxrXb
9F8FogMA+BBJdLrTbiuC6G5ef52HAtEBAHyIJDrRaYbobr92h+LWDYgOAOBL
JNGRzbjWFEF0r9964/Wbv6ZQIDoAgA+RRMeFRmZTBNHduX33zu03KBSIDgDg
QyTRcaGR2RRBdG+8/qYa9xSIDgDgQyTRkc241hRBdK+9ehtXXQEA/sXhqitz
miG64pyKouzywuxtCkQHAPAhkujIZuQ0MpsiiG7utGVzpi5LnLJUgegAAD5E
Eh3ZjJw2b/pyRRDdrEmLZ0xclDBhoQLRAQB8iCQ6shk5jcymCKKbGccsB9EB
AHyKVXQUZDZFEB1vjB83T4HoAAA+RBId2cxI3kTRUTtEBwDwKVbRcdcpguji
x8+nxmljIToAgC+RREc2Y64bP18RRTdu3vTYeVNj5ioQHQDAh0iiI5uR03iV
aoiOW27KmDkKRAcA8CGS6Mhm3HWKIDpqoZg8erYC0QEAfIgkOrIZ15piFh21
TxqVqEB0AAAfIomObMZdpwiiY5YbnRg3cpYC0QEAfIgkOrIZOY1XqYbouOUm
jpypQHQAAB8iiY5sxl2nCKKjlgkjZlAoEB2wUFBQsHz58gWtD+oV9a2lvx7Q
KpBEx4XGq1RDdGS/CcMTxg9LUCA6YGZLenpeXt4777zzZeuDekV9ox629JcE
Wh5JdGQzchqvUg3RccuNGxqvQHTAzNKlS999993PP//8j60P6hX1jXrY0l8S
aHkk0ZHNuOsUQXTccrGDpysQHTBDFSLlTi1sNGeob9TDlv6SQMsjiY5sxl2n
CKLjlosZOFWB6IAZ0sgXX3zxh9YK9Q2iA4pFdGQz7jpFEB233JgBEB2Q4aL7
uLUC0QGOJDqyGXedIohu7KBp1D6q/2QFogNmuOg+aq1AdIAjiY5sRk4jsymC
6LjlRvafpEB0wAxp5PPPP/9Ao3ZSKMyk2g9aHOobRAcUi+jIZtx1iiC60QOm
UPvIfnEKRAfMWETXMfWKOnkltWMrUB1EBziy6PrFkdPIbIogOm65EX0mKhAd
MMNF975GTVyoY8pL1ukWA6IDHEl0ZDPuOkUUnWq54b0nKBAdMMNF956GKrfL
+mRcjdEYF9cxxF9fTumo17Z8fnhB8e20GGsNL60tY2lwB6IDHEl0ZDPuOkUU
Xd84ah/aa7wC0QEzpJE//elPb2pUxIZP0cVWCI0d1pwzprUZ59Z04M3Uxpsq
YjsQ6pI0k00Ys8KrCq9Jn3KD+gbRAcUiOrIZOY3MpgiiI/VR+5AnxikQHTDD
RXdXo3xsqH3SGXXyTFJ7bVpqHFsuLM1eUKM6v3xs+6RyPq03seWNN2svw4TX
5AhEBziS6Mhm5DR+Os4QHbfcoMdjFYgOmOGie0OjPIa0VM+n68lKMeXmRqNN
X1p9Uc+0Vl8ew5ai6Zhy3qAvVq/qjS1pfrsXIDrAkURHNuOuU8yiGwzRATtI
I5999tkdjTJy2qpT6uSpVe21aaGRTYdiyowFwpMMdSGajomJMd5wx1iAtbC3
m2cZK7dOMKhvEB1Q7EQ32CI6brmBPWIUiA6YsYjOQJSbICfmN2kB0Yrm6fD6
NCUKb+dtEB3whCQ6shl3nSKIjltuQPcxCkQHzHDR3W6tQHSAI4mObMZdpwii
45Yb0A2iAzKkkU8//fRma4X6BtEBxSq6bmO46xRBdNxy/bqOUiA6YIaL7kZr
BaIDHEl0ZDPuOkUUnWq5vl1GKhAdMEMa+eSTT663VqhvEB1QLKIjm3HXKYLo
uOX6PDZCgeiAmaVLl7711lvvv//+tdYH9Yr6hhGGgWIRHdmMu04xi47aITpg
JT09PScn5+233/6k9UG9or6l49+MAHaio5BE16czS+ee7DRcgeiAhbS0NMqa
7vc/6dUAqFfUt5b+ekCrQBId2Yy5rjM7HRcW3WMjej82otejwxSIDgDgQyTR
kc1661WqITpuuSceGapAdAAAHyKJjmzGXacIoqMWJrqOQxSIDgDgQ2TRdRzC
taaYRUcCfPxXEB0AwJdIoiOb8aROEUTHLdfz4cEKRAcA8CGS6Mhm3HWKIDpq
gegAAP7FVnS8ShVFR+092g9UIDoAgA+RREc2465TBNFRS88OgyA6AIBPsRFd
h0G8Sg2LTrVc918OUCA6AIAPkURHNuOuUwTRUQtEBwDwL7ai41WqKDpq7wrR
AQD8iSQ6shl3nSKIjlq6QXQAAN9iFV031XWKIDpuOYgOAOBTrKLjrlME0fHG
Lv/WX4HoAAA+RBId2cxI3kTRUXvnX/RTIDoAgA+RREc2465TIDoAQFDwIjpu
ucd+3leB6AAAPkQSHdmMu04RRMctB9EBAHyKVXTcdYogOt4I0QEAfIqt6LjT
IDoAQDCIQnQ/66NAdAAAHyKL7md97EVH7RAdAMCf2IhOdZ0iio43PgTRAQB8
iSy6h/oYyZtJdA9BdAAAv2IjuocsonsIogMA+Bh70T1kI7pO/9pbgej8womE
kEbCCcclOufevR8bvh+rva/Y9flubmf/fRDgiCQ6spmt6KgdovMN7CDV/XY3
N9fedFEZyfvCQREdCBZW0XHXKYLoeCNE5xs8HbgQnYEf+wyiw1Z03GkQnW9h
hat86LI0TyxmhaNbniU1hctgbb51eb2lc26uRRqWpcMNxvtF1RjTbCIhobPj
Vm26LXx+0xz3ValbPGF8hLtCN8TkWOia3QpgytYMRBdQtEPRxiQnEtQpk0/M
s6znp2xFJK5KNIjlrSYPhRcWtuMkOpOLHbukdcOK91WFhAXNfwiE/uuTlk1D
dK0eiC7IqN5hx6aQROn60w9O6yxzFqNim/4Jy4cPc8sxL7nPkiJZUiI7A1u7
ZPOJzP3V8LCqCFs3TKf71H3ToFUC0QUb7bB2ObrtHeIuOsvyLqIz3hRWblOJ
zkEx4VlGzxojOm0t4U/psmnQWoHoAsiJXP2wNco061k727JOepd1YdvlXUtX
YaVSnWs2knA6zaaeta837bdkOpPmcVWRNMvO8Blys2wapWurB6ILIpbLB4q5
4BJLV5tZpjUYZ6zCL6zL64vbXIyw3tEXfruwpLFYQoKNamxXZNNt8waYnbys
KpLowqcA5C1oq4DoWj0QHQAg8EB0AIDA41F0j/70SQoFogMA+BBJdFxoEB0A
IEh4ER1vhOgAAD7FVnTcaRAdACAYQHQAgMAD0QEAAg9EBwAIPBAdACDwQHQA
gMAD0QEAAg9EBwAIPBAdACDwQHQAgMAD0QEAAg9EBwAIPBAdACDwQHQAgMAD
0QEAAg9EBwAIPBAdACDwQHQAgMAD0QEAAg9EBwAIPBAdaC7eu1Cyfn3dbaHl
dp35NQD3CYgONBPkOUI0G2u58F4Ldgm0GSA60Eyo6Rv9x3AbPAeaDYgONA+a
1gS7CYUrTXK0eXwprTVsQ2MxVLwgOiA60DzoWmNn6vQJrjCmL01cesLH/r+k
RG00ckCzF2E6EA0QHWgWrJmcbiuTtfgLtnDdbXPeF87mkM+BqIHoQLNwuy5c
garSu62Zz3Smjr8Qm96zWwyAKIHoQHNgLjb5BVguLqOUDU+KC+uCZPNgOtBQ
IDrQDFjyMeG8HL+/TrjsIC4sOC+8GEpXEC0QHQAg8EB0AIDAA9EBAAIPRAcA
CDwQHQAg8EB0AIDAA9EBAAIPRAcACDwQHQAg8EB0AIDAA9EBAAIPRAcACDwQ
HQAg8EB0AIDAA9EBAAIPRAcACDwQHQAg8EB0AIDAA9EBAAIPRAcACDwQHQAg
8EB0AIDAA9EBAAIPRAcACDwQHQAg8EB0AIDAA9EBAAIPRAcACDwQHQAg8EB0
3vnyyy+vvfrqvv378/LzKWiCXlJjS/cLABABiM4jn3zySdXu3adOn7579+4f
VWiCXlIjzWrp3gEA3IDovEBp266qqueee+6DDz48ff5iakElxZlnL37w4YfU
SLOkvC63c4jROfduE2z8RIK2ImPCPLNRG7Jb513qftN0vUmx62rrWiFovUB0
XqASlZK337/73paSXf+r7+R+01Y8Mjzhn3uOzS7b/d7779MsWsD8jqgOIveF
XUTHNJdwItpPI67HRwe7x656/04a8NkjvKVhvwdoBiA6L9TW1t67d+/Uued/
8uTEvKOXXnjvL7Mu3PxBzwn/1CPm8pVXaBYtYH5Hs4muAZoKsugoG/VsmqYX
nbqEX77PtgVE54W8/Hz61Guytv5y4KTcW/858eqb/3vX9X9Mf+FHD/fLKa+m
WbSA+R1mO+WqBWa4xLyr1bbs7/8JbV5ISwbCr7Uj1kl04QW11vBajbSCvSUh
obOQZ0ibU9d5Qiq1jQ2J/bT9dK4Lyw3WzkiLmbpt+dL4htjS4ffL4hE9Z96c
01bkz+7SbQE+x2adMF0rBaLzAhfdxtzyHz3c919yLv1zxfUfbb3+7ZRLJLqS
qgMfffRRQWGh+R2inYQjxnCZ6Vi3zROsfnPP6ISyKXySjTXandczvUtYNnxo
sya5n05rsF1YWEY79p06Y99t+Uuz25C8TVpDeAPi5py3Epa05Uu26XbEL1zq
A2gtQHRe2FtT8+abbz5z8TLVqt/pMfE7yS98a+MLf9dt4n/rMfbX9/6dZtEC
5nfY2kmfVjMB4WgwG0zO1LyJzpLp6Ep1UajTtFM/XdcgLSxkO6bs0ebCh3u3
bYWvq8/6fdhmex6+HK0xQrcjrlPuBGglQHReuHr16un6+vff/6C0av9/7R7z
o44D/suvBvxT95iDT5+nb4Nm0QLmd7iKToUfUvIRFz58jMyg5UQn9zPiGoSF
zf2xLim8IVrRaV+NTerUcNHpS0ToNkTnVyA6Lxi3l3z88R+u33q9+vCp2mNn
7v3mrU8++cT29hIvolPCLjOVS87FVFSlq7ncs++b07RTP8UG4Qyi44eStu3U
Gfdu2/WKbSMhwVoiyqVrxC9HPL1paYz8dVnXidK1lQLReYScRkKj5O3u3buf
qty7d49eUqP1hmHhBLfD6SzL9YaQkAmp7zUOZI+iE8suR7Uara51mWM/Laug
OQmOC4tloFPpGrnb9h9fsIzULdPFiIhfjnGVIbwy124LX53tOpHQtVIgOu9Q
2kYl6r79+7Nzcihqa2vpJR4BaxGcdBLN7SX3BVx0bZ1AdMB/uJWHDrles9CS
2wauQHTAV/ByEVkTiA6IDgAQeCA6AEDggegAAIEHogMABB6IDgAQeCA672Ao
dQB8CkTnEQylDoB/gei8IA6lfunyK8dPn6d48eWrDkOp382VxzhrDC6PgOmP
JDV2Q66baA6acLv37yM4DUqAm/p8AETnBWMo9aeePnv2wgsvvnLj8tXXLr54
5dyzF304lHpUm7h/uA134OEtjVnGOw3oZIvjl342KxCdF/hQ6sxsz11++dqt
qzdev3Xn3r1//+1rN1+/eeuW34ZSj2oT9w+I7j7hl342KxCdF/gIw8dOnX3l
+u3Xbr9x983fvP32f/7+979/553fv3r9hq+GUlei2YTicKRHNWq67Xjs0qdW
12wZ1dzcT/mL0pHW72VVlm/Gfsx4L510/k4cexh5XHfxWzNtyHHrxrTlW/I4
oH3Qgei8wEVXf+7C62+8+dv/+B0p7qOPPvr444/pP3fv3fPbUOqN2YQ+IpP3
UdMdhy2SOy902WnoS4ezlFaLe1qVnS7kwUcidtLpOzGwnsVz/KWsk+YNuQ78
bv8tuf40bQmIzgt8KPVr11+7dfsOt9ynn3762Wefffjhh++8847fhlJv6Cac
+u8+/HhU47FL0479FHD7Mr2tyqb/3jvp9JuK3bP+Y0AeB1W221Dkd7l/tDZa
2EJ0XjCGUn/l6rX/eOstyuVIdH/4wx/ee+89/w2l3uBNOPXfw6jp0YzHLqrD
qZ8y9l+mx1XZ9N9zJx1/U7FnTS46YxVeROdhQPs2AETnBXEo9bd+9zt2gu7d
dz/88CNfDqUe3SaabNR0yxhykQ5tt37aYPNlel2VSzUXnejsPmbE0tVl9Hhp
Q3qrydvWX8f9o0F0EJ0b0QylLt5H53DcmcukE806lHpUmxB627BR060LSyt2
HNHd2k/xLZbuuRnD5SPb9t97Jx1/U7tv0Hoxwl1u8oZsBn63/jrSt+RxQPug
A9F5B0Opg5ajjQqqqYDoAPADEF2jgOgA8AMQXaOA6AAAgQeiAwAEHogOABB4
IDoAQOCB6AAAgQeiAwAEHogOABB4IDoAQOCB6AAAgQeiAwAEHogOABB4IDoA
QOCB6AAAgQeiAwAEHogOABB4IDoAQOCB6AAAgQeiAwAEHogOABB4IDoAQOCB
6AAAgQeiAwAEHogOABB4IDoAQOCB6AAAgQeiAwAEHoiurVFQULB8+fIF/oF6
S31uDR/B2hPgFyC6NsWW9PS8vLx33nnnS/9AvaU+U89b/CNIPQE+AqJrUyxd
uvTdd9/9/PPP/+gfqLfUZ+p5i38EqSfAR0B0bQqqvygzaX5FNBLqM/W8NXwE
sSfAR0B0bQo6SL/44os/+A3qsyi6FvwIYk+Aj4Do2hTcEh/7DavoWkNPgI+A
6NoU3BIf+Q2r6FpDT4CPgOjaFHSQfv755x80FeezY3WW7L0ttAqvmgLqsyg6
y0e4ktoxpNEx9UpTbpmonSSsVOwJ8BEQXZuiKUXHLGcI7fbeJcaL5hWdKrlJ
teGXqbV2q2g4EF0QgOjaFNwS7zcBt6qXxGads204lxW7pPpWU2xExyo6fc5L
KR1DcTVNuS0LNXGhjikv2fQE+AiIrk3BLfFe47nJtHZWblpSfZMmzjLRaROx
8lINwio6bcZl1XN2byE9aWjzVV+laK0dUy6/J6zCtKDcoL5RXxyi8ykQXZuC
DtI//elPbzaeF7cvXLj9RbkpNu0pmngqLZbmGS+bAOqzKLrwRzi3pkOHNefc
3loRG+JL0EQoFFuhtWlT9P6QeQXG8mxSnRJazD0BPgKia1NwS9xtPC9ULIjd
fERuWlDxAk0c2RxL24nlL5oEq+i0GWeS2ofGltu+p3ysntK1TzrDX/MJYdr6
dtYiwGaKb7wL0fkUiK5NwS3xRhNwiUy36Yhtw5FNsarpTLMbhVV0+px6ElNM
ueUN4Waaap9UTxPlMSE+IUxb322zPvGNb0B0PgWia1PQQfrZZ5/daRIOk882
HRZeLCh/Xp9mk9r/NQXUZ1F0po9QFkP7ZEyZ/vLUqlVlamP7VafUl+21KaPp
ju1scXWWlnCD2BPgIyC6NkVTiu4O15uGobw7YcM9X74gtklk5ya6O1xXRp3K
naQ3tY+Jae8iujuaKFU0W4priymD6IIBRNem4Ja47TesomsNPQE+AqJrU9BB
+umnn970G9RnUXQt+BHEngAfAdG1KbglbvgNq+haQ0+Aj4Do2hR0kH7yySfX
/Qb1WRRdC34EsSfAR0B0bYqlS5e+9dZb77///jX/QL2lPosjDLfUR5B6AnwE
RNemSE9Pz8nJefvttz/xD9Rb6nO6/i81tOBHkHoCfARE19ZIS0ujnKQx/xhW
M0O9pT63ho9g7QnwCxAdACDwQHQAgMAD0QEAAg9EBwAIPBAdACDwQHQAgMAD
0QEAAg9EBwAIPBAdACDwQHQAgMDTYNEBAICPaIDo6C0IBALhr4hWdB8DAIDf
iEp0nwIAgD8hg0lOcxIdAAD4Fy+iAwAAv+MuOgQCgQhSQHQIBCLwAdEhEIjA
hyG6E0fqW7CUBgCA+wf5jSz3wNcf5LpDIBCIQAZZ7v8DX3x8YQ==
    "], {{0, 336}, {419, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{419, 336},
  PlotRange->{{0, 419}, {0, 336}}]], "Text"],

Cell["\<\
First, using the \[OpenCurlyDoubleQuote]Browse...\[CloseCurlyDoubleQuote] \
button do select the zipped archive from where you want to installa the \
application. Note that if you already have some packages installed, this \
process will not cancel the existing folders. It only adds new packages.\
\>", "Text"],

Cell["\<\
When you have selected the archive, you have to define where you want to \
install the application. There are two possiblity:\
\>", "Text"],

Cell[TextData[{
 StyleBox["Install for this user only",
  FontWeight->"Bold"],
 " if you want the application be available only the for current logged user"
}], "Item"],

Cell[TextData[{
 StyleBox["Install for all users that share this computer",
  FontWeight->"Bold"],
 ", to make the application available to all users."
}], "Item"],

Cell["\<\
In the first case the installation folder is given by the variable \
$UserBaseDirectory and the full path will be\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNameJoin", "[", 
  RowBox[{"{", 
   RowBox[{
   "$UserBaseDirectory", ",", "\"\<Applications\>\"", ",", 
    "\"\<GeometricOptics\>\""}], "}"}], "]"}]], "Input"],

Cell[BoxData["\<\"C:\\\\Users\\\\roberto\\\\AppData\\\\Roaming\\\\Mathematica\
\\\\Applications\\\\GeometricOptics\"\>"], "Output"]
}, Open  ]],

Cell["To check the content of that folder run the command", "Text"],

Cell[BoxData[
 RowBox[{"SystemOpen", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{"$UserBaseDirectory", ",", "\"\<Applications\>\""}], "}"}], "]"}],
   "]"}]], "Input"],

Cell["\<\
In the second case, the installation folder will start from $BaseDirectory \
and will be\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNameJoin", "[", 
  RowBox[{"{", 
   RowBox[{
   "$BaseDirectory", ",", "\"\<Applications\>\"", ",", 
    "\"\<GeometricOptics\>\""}], "}"}], "]"}]], "Input"],

Cell[BoxData["\<\"C:\\\\ProgramData\\\\Mathematica\\\\Applications\\\\\
GeometricOptics\"\>"], "Output"]
}, Open  ]],

Cell["To check the content of that folder run the command", "Text"],

Cell[BoxData[
 RowBox[{"SystemOpen", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{"$BaseDirectory", ",", "\"\<Applications\>\""}], "}"}], "]"}], 
  "]"}]], "Input"],

Cell["\<\
When you have done all needed selections, click \[OpenCurlyDoubleQuote]OK\
\[CloseCurlyDoubleQuote] and an installation progress window will appear, \
like the following\
\>", "Text"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQd0Fkea7y3f79xz9t777bl79t7dnf12d+7uxI3+PB5/jAcnbAM2DmDj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    "], {{0, 210}, {619, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{619, 210},
  PlotRange->{{0, 619}, {0, 210}}]], "Text"],

Cell["\<\
wait until it ends and then the software is fully installed and ready to be \
used.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Manual installation", "Chapter"],

Cell["\<\
In the event that the automatic installation fails, do the following steps to \
install the application.\
\>", "Text"],

Cell["There are two possible scenario: ", "Text"],

Cell["\<\
a) First installation: it's the first time you install GeometricOptics \
application\
\>", "Text"],

Cell["\<\
b) Incremental installation: you already have some chapters installed and are \
going to add new chapters.\
\>", "Text"],

Cell["Scenario a) - First installation", "Text"],

Cell["\<\
a.1) Delete previous failed installation removing GeometricOptics folders \
from the position you indicated in the installer. The possible paths are\
\>", "Text"],

Cell[BoxData[
 RowBox[{"FileNameJoin", "[", 
  RowBox[{"{", 
   RowBox[{
   "$UserBaseDirectory", ",", "\"\<Applications\>\"", ",", 
    "\"\<GeometricOptics\>\""}], "}"}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"FileNameJoin", "[", 
  RowBox[{"{", 
   RowBox[{
   "$BaseDirectory", ",", "\"\<Applications\>\"", ",", 
    "\"\<GeometricOptics\>\""}], "}"}], "]"}]], "Input"],

Cell["\<\
a.2) Open the folder where you want to install the application, still one of \
the two options\
\>", "Text"],

Cell[BoxData[
 RowBox[{"SystemOpen", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{"$UserBaseDirectory", ",", "\"\<Applications\>\""}], "}"}], "]"}],
   "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"SystemOpen", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{"$BaseDirectory", ",", "\"\<Applications\>\""}], "}"}], "]"}], 
  "]"}]], "Input"],

Cell["\<\
a.3) Uncompress the GeometricOptics compress file into that folder. Be sure \
that the final configuration is something like the following\
\>", "Text"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQdcFFm6/w333vfeu/e99/++d3bv7t7d2XFmw+zu7M7OGEd0zDmhoqJk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    "], {{0, 343}, {633, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{633, 343},
  PlotRange->{{0, 633}, {0, 343}}]], "Input"],

Cell[TextData[{
 "a.4) Restart ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and check if the Palettes menu has the item \
\[OpenCurlyDoubleQuote]Geometric Optics main palette\[CloseCurlyDoubleQuote]. \
Use it to work with the application"
}], "Text"],

Cell["Scenario b) - Incremental installation", "Text"],

Cell["\<\
b.1) Open the folder where GeometricOptics is installed, and go to the \
subfolder Packages; it has to be one of the following paths\
\>", "Text"],

Cell[BoxData[
 RowBox[{"SystemOpen", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{
    "$UserBaseDirectory", ",", "\"\<Applications\>\"", ",", 
     "\"\<GeometricOptics\>\"", ",", " ", "\"\<Packages\>\""}], "}"}], "]"}], 
  "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"SystemOpen", "[", 
  RowBox[{"FileNameJoin", "[", 
   RowBox[{"{", 
    RowBox[{
    "$BaseDirectory", ",", "\"\<Applications\>\"", ",", 
     "\"\<GeometricOptics\>\"", ",", "\"\<Packages\>\""}], "}"}], "]"}], 
  "]"}]], "Input"],

Cell["\<\
b.2) Uncompress the GeometricOptics compress file into a temporary location \
and go into Packages subfolder and copy all subfolders you find there (the \
names and number of packages depend on the chapter you are installing).\
\>", "Text"],

Cell["\<\
b.3) Copy selected subfolders into the destination folder, the Packages \
folder opened at step b.1)\
\>", "Text"],

Cell[TextData[{
 "b.4) Restart ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and check if the Palettes menu has the item \
\[OpenCurlyDoubleQuote]Geometric Optics main palette\[CloseCurlyDoubleQuote]. \
Use it to work with the application"
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["How to use the main package functionalities", "Title"],

Cell[TextData[{
 "Once you have installed the package, to check that the installation is \
completed and successfully, restart ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " and into the menu \"Palettes\" you should see an item named \"Geometric \
Optics main palette\". Click on it and it opens the palette like the following"
}], "Text"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnQl4FEXaxwcUUORaDi9AFA8UBUFXWXHFRc4QLnEBedgPFjwA/RYh+KnE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    "], {{0, 98}, {546, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->{546, 98},
  PlotRange->{{0, 546}, {0, 98}}]], "Text"],

Cell["Here is a brief description of each function ", "Text"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzt3Xm8rXP5//HLOcc8Ox1jZvE1ZgghmX5UkmQmIvNQyJBUOtJEJb5EIhKJ
jE1KKk6R6ZtZJGNRMssQGn/X1Wft2rY9rL33Wvf7utf9uh6P57dH/fE9+3N9
pnXf92dYfLcDt9xrgpkdMpP/ny3ff/gGBx/8/iO2msv/yzYHHLLv3gfsucc7
Djh0z733PPjNu030/9EmFJP8P/71r38BAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAADUhsd0bhY3xS3mlnH/g2Et08pV5GzWyKG6HgEA
CK15fUG3jtvJHenOdFe5+93j7kX3T/cvjMs/W7l8vJXbae7r7hNuZ/cWtxC/
EwAAneYx2W3qPukud08nmBfxas+6K9yn3GZuXnW7AQDUi8ccbhv3DXdvgrkN
Y/OAO9ft4OZUtysAQD4ei7sD3E/cXxPMXeisv7bq9gNuEXV7AwDoWHmvf7C7
PcH8hGrd5D7o5la3QwBANTzWd99yLyeYh6D1kjvHratulwCAzvOYzcqz/j0J
5hzkdLf7kJtN3V4BAONjZQ/5h90TCeYX1EO0lWgzs6rbLwBgdKycu3OYlX3j
6vkE9RRtJ9rQLOr2DAAYnsdEK+v4H0swf6A3RFs60E1St28AwGt5rOVuTTBf
oDfd5tZWt3MAQGFlH9/pxnm76L5oY2e416nbPQA0mcfu7skE8wKa5Sm3p7r9
A0DTeMzjvpNgHkCz/cBNUfcHAGgCj3XdwwnGfiD80W2k7hcA0KusrO2f6v6e
YMwH+vuH+5yxRwAAOspjXit3v6vHeWA417vXq/sLAPQCj2XdgwnGdqAdf3Ar
q/sNANSZx0bumQRjOjAaz7tN1f0HAOrIYzcr97arx3JgLGKdyn7qfgQAdeLx
mQTjN9AJX3TTqfsUAGTn8fkEYzbQSSep+xUAZObxqQRjNdANX1L3LwDIyOPj
CcZooJuOVfczAMjEyj3r6rEZqMKn1f0NADLw2CPBmAxU6VB1vwMAJY/1jT1+
aJ44L/id6v4HAAoeSxp396K5/uyWVfdDAKiSx5zurgRjcKe84O52P3cXuVPc
UW5/t41bz62MtrzVbeX2cUe6E9157qfuNvdsgvrulHvdPOr+CABVsHKP3+UJ
xt7xeNld1Zqf1jbufauy/Uxwb3KHux+7FxO0h/H4Ke0HQBNYPc/2i7Nc4263
z1q5k2BmdR7xn/Y0g1vXyvuWX1g915OwLxBAT/NYpzWXqsfbdsU32ji/dWF1
7tB2G1vQfc7qdW9UrAdcX507AOgGj9nd/QnG2nb83h3i5lDnDWNub7O5A9wD
CdpTu21uLnXeAKDTPM5IMMaO5Ca3o/E9tmdYWW+yrbshQfsaybnqfAFAJ3ls
kWBsHU6sw95YnSd0vR1u4O5J0N6Gs4M6TwDQCR6T3RMJxtXBxHfX4431fI0R
de2+1Kp7dfsbTKxbWECdJwAYL4+TE4ypg/mtW0edH8ja5TqtNqBuh4M5S50f
ABgPjxUs33r/eO6L5z+e+RvOyruA4y3fu4B/ujXU+QGAsbJytol6LO3vPre2
Oi/IxeMtlm+fwHVuOnVuAGC0LN+av5vdFHVekJPH/FbOF1a30/52UucFAEbD
Y0bLtdf/GjenOi/IzWMud22C9trnETerOi8A0C6PDyYYO/vEGfGzqHOCeoi2
0moz6nbb5yPqnABAOzymd79LMG6GS9wM6pygXqzcKXBBgvYb/uRmUucEAEbi
8f4EY2b4hpuozgfqyco9g6cnaMdhP3U+AIyNxxxuTbeD+4g7yO3iNnazqf++
DpYzxszfJBgvzzXWTqMDWr8j1e35AX7LAvVgZV9x3BMb98XGvbHD7YGP+0qv
dntazd9Ve2ydYKz8tbFmCh1iZT3AHQna9XvVuQDwWh6T3Nru4+4q9/IY+3jc
AbabujzjyMPN4jHyBbesOg/oLR7LuOfFbft2450WIBf90K1s5Y7Yy7owNpzn
ZleXc5Q5WVs8PoYd1XlAb7Ly7U7dvtdT5wFoIo+l3b7uQvdkBX093jnOrS73
KPLzVfHYeIo6B+ht0cbEbfzr6hwATeCxsJU1emdbOYdD0d/j3Jr0e3/ib3TP
CsfFX7kZ1XlAb7NyrtVNwnYe7xlZ2wJ0mMcUt6071XLdC3aaOjdt5G57YX7+
7BZX5wDN4LGEe07Y3t+nzgFQd1b2qsUdoMdaOff7nwnm+sHE3/Umdb5GyOWP
hPn5mLr8aBaPTwjb+5Xq8gN15DGb29Kd5Z5IMLe36xp17obJ6QKmu+P3ceuh
8xNQDx6zC8ePeB5YVJ0DoA6sfMffz8oz6lj35WWwnDqXQ+T3AGFODlKXH83k
8SFhuz9MXX4gIyt781ZznzT9fvROOlqd2yHyrXr3/7DVYG0kepOVNa8Pi9o+
3wCAllZf3NTK2j3VWv1uu1Wd50HyHuccviTKx17q8qPZPPYQtf1XjO9eaDCP
ed1u7lIr576p5+due1Gd80Hq4B2iXNzrJqnLj2azcu7nPaI+8C51+YEqeSzv
jnDXun8kmJOrNr+6DgbUx4miPHAWOlLw2E7UB05Wlx3oNo/V3Qnu/gTzr1qq
s+2tPIdXnYO4D32CuuxAsLKP+I+CfnC/uuxAt3i8x8r5d+o5N5MF1PXSr36W
FOXgK+qyA/15nCzqC0upyw50ksfc7uIEc21Gada7W1l7ocjBRuqyA/15bCDq
C7W9KxQYyGM5K3fgqufZjO5T18+AujpDkIM4c2WiuuxAf9EmrZxFVXV/OENd
dqATPBZ3f0gwz2b1VXUdDagvxbrn09XlBgbjcZqgP9yjLjcwXlbO5b0vwRyb
2XvU9dSvvqaIcvA2ddmBwXhsIuoTU9RlB8bDyvp+9fyaWayzT/Pe22MLQQ6e
dtOryw4MxspZAE8J+sUW6rIDY+WxijVzL/9opFrn4/EFQQ6+ri43MJxoo4J+
8QV1uYGx8jg7wfya2TRL9OzfqrPrBHnYVl1uYDjRRgX94jp1uYGx8JjL/SXB
HJvVo5bvzL848/8VQS4WVJcdGE60UUG/iL44s7rswGh5vDfBHJtV7CdaTV1H
g9TZWwW5eFBdbqAd0VYF/eOt6nIDo+VxbIJ5NqMYQ5ZW188QdfZRQT7OUZcb
aEe0VUH/+Ki63MBoeVyWYK7N5O/uy25udd0kq7N91OUG2hFtVdA/LlOXGxgt
K/f4qefcDJ51Z7oV1XUyQn1N554R5GcFddmBdkRbFfSP6JPTqcsOjIbH1Qnm
XpXfWLk3ZHM3o7ou2qwvxjZgGMZvZKAtHj9LMA9X5XdWnvF3spqsZbey1n9t
9yF3nmnuZuDdJmrFNN/Ift/qowe5tSzRXWHAYDz+N8G83C2PufPdnm5Jda7b
qIu4x3x59373FXez+1uCPLK2CbVimjWyA/3V/cqd4nZx/2O8R0MiHtsl6Ced
Et/wv+sOsPKePHVf81jIvccd4650zyXI4WDY24RaMc0e2XbHqJ+4z1j57pjq
bBE0i8cCVn6nqvvFWLzornAfcatbsjP6BuR5Drdh62+9xOpzz2K0Dc42Qa1Y
+W5Wl3Etvkte4A5167pZ1PlDc3iclKAPtDsXxXrFT1r5fT+DOndD5HN6t6qV
fUhfd7+2+t6vwNmmqCXTnJHdCbEH+Vb3Vbe7lXeZE9T5RG/ymM+9kKDdD+a3
7ovu7W5Wda6GyN8Sbgd3vPuleylB3jrli+r8AmPRGjfU/adTnndXWflWuKVb
SJ1f9A6PTydo4yGek+NMgsPdsuq8DJKn2FsU9yUe4n7gnkyQs27iblPUkmnu
yK7SI+4it3/GsRL14TGne0DUjuP+oVi3t5ubV52LQXKzjNu31dd6fb4faIo6
/8BYRNtN0H+q9Ef3TSv7hxZV5x/14vF6d09FbTX25n3NyhrYVOvLPBZxu1q5
F/mRBP1a5R51XQDjUeF4ltH97jS3vSV8rkI+VtYC3NGl9niXle9XcTZGmvUs
Vp4T4t7wWG9zb4J+m8WZ6roBxsPKeV/qfpRFjOtx3ks8c82prhvk5DHZ/bgD
7S3Wsf7cyrfypdTl6le+2Iv3Livr9W53/0zQNzPaTV1XwHhY+aao7kcZxdh8
o/uc29iSvYOFnsdb3E9H2a5inerF7n1usroMrXLM5DZyn3XXt9q+uv/VwTLq
ugPGw8raHXU/qoNX3DT3CbeOm15dd8jByu+AU608yz/er83Ec/ND7odW9tps
agnu0fGYZOXM/I9bOVfv5QT9q24eV9cj0AkDxiy0J57jYlyPM4niLJM032uh
ZeX7wIqWaD++x9xuRyvn/T+boP/U3XfUdQp0QrTlBP2p7p5wZ1k5rzzNuI/m
8ljSyl1b8Yyf4Z6cXnKoun6BTrDyDKvuT70kzjeL+xX3tprco4r6s3I/Xuwd
iDUrv07QD3rZGur6Bjoh2nKC/tSr4htwrCOMb60rqesavcVjFvdud4aVMwPU
7b0J2PePnmLNPgegSg9a2WMY661ZQ4hRs3In4V5WztftpbP06+IQdRsAOsnj
sAT9qmliHdZ5Vs4f4rwBDMljJSvvkOJdEvvxdWIf0OvU7QHoJI95rT73Afei
yH3sJT/ALaZuD5D3x9ijF+dOxN3DDyVonyhOV7cNoBus3MWt7l8obnOfcqur
2wUq639xd16cJXCKlf0k6jaI1/bJWdTtBOgGj9mtnEGu7md4tQetrOlm/WAP
8ljZHet+l6CtYXBPuyXUbQXoJo+l3Z8T9DcM7k73Mbekuq1gXP1sKXek8Xu7
DuL+5bep2wxQBY/NrKxzUfc7DO8GK+e7LKBuM2irXy3Qqq8bE7QdtOdWt5y6
7QBVsrLeuFv3nKKz/mHljLc93NzqtoNX9aO53O7uZ616UrcVtCf2WBznZlC3
oSbxmNnKWvQ4uzK+i8XZ6m9w8xvnqlZdFzNauQOU/Ub1Ee9tvud2oL/I+k2c
ybOdlXO1eY9WLze7j7ql1e2orjymWFnHuouV/UzxvfIYd7I7213qfmLlrsk4
p/L37hlr797J+A0d36cfcXdbeZcWv62jr51jZe1srKWJvbIHuve7DYxzWMdT
n0u3+sTNCfon2veilfMFNjeeY7rdR2Lt/katMej5BHWPkcW9h//nTnP7uMXV
7agurDwbLu+2dEdYufvkOivrJNX1OpTn3K/cuVbucY3f6PGOgT0d7df74q2+
clorl9wdWg/RL09366jbUC/xWNDK8839CeoYQ4ux/2orZ2/uauX75iR1+8mu
1b7j+TnG/HgX/MNWW++lb1nxfjveQcQ7iS+7D1g5e2MRN526DjLzmN690cp7
lhPdNcbzT3ax5vwQN0XdfurIytk88U4lvrO0884S1XrSXWHlPXA848X7S8bx
kdt13B/1Jvdhd7mxDyzE3o9pVt4XxDcNzmxvrx0tY+Ub9OetnGv3VIK6xKvF
t+kL3CZRZ+p2k52VNUmfdX9MUHcoHrbyO+woK/cgLaxuJ3XisYKVb/Tx/fyZ
BPWZ3QtWfhvFb6T4rcS42X5bW9S9xx1t5e4SxtE8HrLyG5fx89Vtdia3o5X9
FayD1brPfdt9xMpvVt5fjb49x7kTcXfU+cZ9kZ0Qv5nit1P8hlpBXb914zGf
e4eV9YUXGWedq8V3vfjGF+t6Gvuuy8r34fielXk9Uy+L+zBiffhxrbY4n7pN
1JHH693OVs5253zJ7ovfVPHbKn5jLaWu/zqysuZkWytrdW4yvrEq23J8v2nE
Xigra5p3Nc7nUYjnqPjdGc8B67mZ1e2hrjwWtrIm/84E9dp0D7hPu2XU7aKu
PGazsrdqqpV1Pc8lqNem+YWVe4p77p2Ald+bcdfS4wny3BQxLsZeyVhXHt+g
WZ83vjYcY+QuxjlTmcX7rP3cPOr2UmceE90qVvZpxLuWhxPUbVP8wcp+t9rf
ge6xpvuWce91t/3Nyj77E9w2xlksnWq/sc461kF808pZH+p6Rnti3fUlbgvr
wecpUV+IvZqxTivOmIp7OvkN3F0vuTPdG9V1P8p2Mn2rnVyfIIe9KuaiH1u5
32hD4xzKTrfheF8S3+X+kKCuMT6xVzXOHFhD3a56icec7m1W3uteZZxT1E3T
rKzRmqiu92HaQ5xJGvMRe046L35rx/N97I2Ms2I4a7Lz7TfWScfdUZzB2rvi
PONY/7KIur31Giv3SsTvgVhPfHuCuu5FD7nDLNEdRFb27H/N+P3XjbqOM0Dj
fT7fM7vTduP9fuyXvszKNxR1naMasc849hvvZJxR2a2+NX8rv3EfBc+EnRXv
f+Odlux3rMeyVtaXsXekM561cm9LrF96g7r/9jIr50vGnr27EtQ7tB50e7sZ
1e2yl1n5pnaw+5GxlqZTYl3dGVbhfGHlLOo405D1H+MTz5txlvdUt7Yl/rbT
KzxmsLJvnLskMFDcdxj3GbIvtvv9MPaBx3fMz1m544i5ZHziGTzW2XftfCyP
1a2cA6sua53d406ycrfBHOp+2BRWvk3G2P5IgjaA3OJMlsPd7Op22xQek63c
IxLfkTlDa+ziu1bse1mtg3UTd3L8OEHZ6iie8eM7Y6wrW0Ldz5rGY3YrZxlz
Di9GK84lnWqJ1lo1hZV7r2OdZuwh40z4sYnvLGO+i9jKmT0/SlCOuok73eIM
/dgDydihGT/mcZ80zpbG+MVZePGemrswNH051hHuYeXd818StIe6iTl8oVHm
PNZEP5ngb6+LeGcV7/XjTnPOG9GNFbGHL/btcz86Oi3WrB1vnK2l7N+zWLmD
NNa88U6vffEctH2bOf5Sgr+3DmLdStznuLK6XzSdx9xW7jJ5KUG7QG+Lfc6n
GO8D1H0+9u6u5Y4x9vG0K9ZXDHkOvMf+Cf7GrKLfx7uUOE9/VO9T0LUxYDor
90lxrwSqFs9UsW9wgrofIKrj3/dux/7Cacae9OF8bIj8rWecgTJQ7K+M706x
NnU2dRvHq9pr7Ce+OkEbQbPdYB1cb42OjA2x/mc3466uwcR6ys0G5CvWSfMM
9V+/dPu6yeq2jNf07biH74vGb1XkEXNMnMc2l7p/4DXjxULuUHdLgnaSRaxR
f12/HB2Q4G9Si7PBP+4WV7dZDNmXtzbuIkVef3I7q/sJhhw/lrNyh8pDCdqK
2kdaOYl1FPcm+HsUHrWy3pH3d4lZ+bZ3eYL2ArTj5255db/BkONJrBuKc21O
dU8laC8KsWdtontXgr+lSrGf9xtW9upx5m5iHjO5o4y7pVA/sXYo9qJyN3di
Vs4Ej/NY40z7pu0fir2UTdjvF33x+25743zvWvB4u7svQdsBxiO+V22l7k9o
a8yZw8p+op9aM9YNxtz/3QR/R7dca+U+vdep2xba7oNx3tdFCdoO0Emxd3gx
df9C2+NQnH8b+wlvTtB2uiXm/l8n+Ds66TfuSOO8/dqx8k2Gc71GL/aixzg1
zcp7rrgL7DR3nJXvJ4dY2aseZ1LH97713WpuGfcGt6qV/b/vtPKObE8rY99U
9wUr30nPtbIX9iorZ189kaDcdRN3fG+p7mcY9bgUd91/2spd0eo21Ekx9/fC
N49Yd3uCe5O6rWBM/Wtiq3814Z3bWMWZJrFO9wdW9j/GHL2um1dYb7HPOu6u
fr871n3Hyj6avybIV2YnuhnU/Q6jbu+xbnAdK+c/9sL5+HWe++OM97Pd24x1
fLVlZX/uzxO0pyzinPm49yzWqB7htrSyb6k284XHJLe0lXVVh1k5r/0aK/uO
1fnNIt6h8I6ypjymt/Iu7XzjXqIq3Wbl2WcWdRvAuPtQrPFr+nvkV6z8/plq
5Xm+Z++PsvKeZw13uJU7xV9MkH+l+B6wtbpeMO52HesG4+x87iHojnifGHfq
rquua3Skv8TzYdzb0cS7veMbx/+1yr+JNfh3rJW9V/GbJ+7RmmbN3ecZd4fO
qK4PdKRNb+guMe4g6IQ4n+co487NnuGxsJV3weq2VaU7rXzzjf22nBE7dNuY
2W3kPuOus2ad8XyTW1JdB+hYW1641Y5Zzzx6MT/EOuSefRfaRB6bWW+sm2m3
De/l5lPnva6s3EuyrZU9DU34LRDrI7ZR5x0dbcPxjmsnK79n1e0rs1hDEfcT
r6yuM3S8D8RamdhH1uvv++O8oqOM57hutKF53YFWnpPV9dxtJxvfA3qOlT23
Z1q919132v1W9ifPra4fdKXNL2q9/dv3GfdVt446101hZT9ErJ/o5bug4jyH
pdS5Rlfa72Qr+2IeSNDOFOI5MM7DivNGJqjrA11r57HWuxff98d61DgLJ+4j
5DlN177i7rJYLxB7JV9I0C46LfYHrK/OM7rafuOb6OXW++9G+8Q6fn7X9jgr
5zL02ph8q/ugm6LOL17T3mZ1O1s5n1DdTjop9kRwf0CPs3IO57cTtLdu216d
a3S9Lcc5s710BlzcI/FOdV7Rdvtb08qaQXW76ZTYM7qPOq/oervdPkFb6zbm
/x5mZY1Wr7zL+pnbUJ1TjLktvtHKva69cq70VHVO0dX2yvyP2vL4bIL21Qlx
xv5a6nyiY+3yf6ysEeiFPYRx9jxrpnqQMf+jhqyc6/q1BG1rPOKdRdw7vIo6
n+haO13cyl2GdT9n8EJj3WnPMeZ/1IzHTFbufVO3q7GKczrPccuqc4nK2mzc
OXW81fv+gSvdHOpcoqPtkvkfteExp/tFgjY1Vt8y7mBrLI8pVu4Nr+tZ7XFG
AOdL9ghj/kdNeCxg5S5GdXsai98Y6/rQ4rGS+2WCdjkWceYk5032AGP+Rw1Y
2atax7Or4ozpj7kZ1DlELh7Tud2tnudV/clYt1J7xvyP5KzsqarjnVaxpn9x
df6Qm5WzWU+3+u1hjbuD1lPnD+Nqe8z/SMtjSSvPGuo2NBq/c1uoc4d68Xiz
uyVB+x2N54z3ALVlzP9IymM+K3c1qdtPu+L8wWPdrOrcoZ6s7GuN86z+nKA9
tyt+n7MeoIaM+R8Jecxh9XoW+rlbXp039AYra13PS9Cu2xW/09kXUDPG/I9k
PGa0+typEvdqc046usJjU/dEgnbejvi9zvkANWLM/0jEyv2UFydoM+24x71R
nTP0NitnB9XlzIs4I4hzAmvCmP+RiMdXE7SXdsQ5PrOp84VmsLIu4DNWjz0C
caY19wXUgDH/IwmPTyVoKyOJ/fx7qnOFZvLYxD2eoB+M5CvqXKGt9sT8DzmP
DyRoJyOJM/xWVOcKzWZlbeC0BP1hJFPVucKIbYn5H+o2uJ3lvy897uvhfT9S
sPI94Oga9BvWxiZmzP/Qtr//515J0EaGEu/7d1fnCRhMq/9kPh8rfp9spc4T
hmw/zP9Qtb03uecTtI+h3OVWUOcJGI7H/O5nCfrLUF5266vzhEHbDvM/FO0u
vmFmPtM/xtPZ1XkC2mHle8CZCfrNUOI8wzeo84TXtBvmf1Td5mKsmpagXQzl
AuO+PtSQxzEJ+s9Q4nwgzgZIxJj/UX2by7zP72Rj7zJqzONDlvecgFPU+cGr
2grzP6psbxtb3jXLR6rzA3SCx07ubwn61GC2UecH/2knzP+oqq1l/eYfv0f2
UucH6CSPd7gXE/SvgWItAPcFJmDM/6imncU3/6sStIWBYm3ylur8AN3g8Wb3
VIJ+NtCvjDU2csb8j2ra2ScTtIOBnnXrqXMDdJPHcu7hBP1toJPUuWk6Y/5H
99tYnFGS7Zv/o8bdfWgIj4WtnGeh7ncD8e5N2y6Y/9HN9hVnk2Q7n+x+t7g6
N0CVPCa7/0vQ//p7lr4obRPM/+hW25pg5T5wdf33F79FllDnBlCw8hvg7gT9
sL8bjbUAqvbA/I9uta2jEtR9f7HueGV1XgAlj0Us33qA49V5aSJj/kd32tWG
luubf6zz30CdFyADK2sCs+0LeLc6L01jzP/ofJua13J98+cOMmAAj7Us1/kA
T7tF1XlpEmP+R+fb1DcT1Hl/3EEODMJjU8t1TuBl6pw0iTH/o7Ptaf0E9d3f
VHVOgMw8drZc9wVsoc5JUxjzPzrXlqa3XHuMuWsEaIPHwQn6a5/fuVnUOWkC
Y/5H59rS4Qnqus+Fxj1+QNs8jk3Qb/t8Vp2PJjDmf3SmHcWeohcS1HWIMwe4
ZxwYJY8zE/Tf8IpbRp2PXmfM/+hMO7okQT2He9wc6nwAdWS57un6qTofvc6Y
/zH+NrRpgjoOLxln+gPjYuWe7iz7d7dT56OXGfM/xtd+ZrJynr66jgP7/IAO
sDx3dv3Bza7OR68y5n+Mr/1kudf3AnUugF7icXSCfh2OU+eiVxnzP8bedpay
cq6uun7vM775Ax1lZS1Ahvu74nyiFdX56EXG/I+xt53LE9RtrBNeTZ0LoBdZ
nrUAV6tz0YuM+R9jazdbJ6jXcIA6F0AvszxrAXZR56LXGPM/Rt9mZrMc94de
qs4F0ASWYy3AY24udS56iTH/Y/RtJsOav4cYC4BqWJ61AKwF7Gy9Mv9jNO1l
DveMuD7/6tZU5wJoEsuxFiDuK56izkWvMOZ/jK69HJGgPg9T5wFoIo+NE/R/
7gboXH0y/6PdtjKLe1xclze7iepcAE3lcY54DPiz8e2vU3XJ/I9228pB4nqM
O8rfrM4D0GQe87lnxWPBkeo89AJj/kd77WRGK2dxKuvxdHUeAPx7PPiAeCx4
0s2mzkPdGfM/2msneyfo75PVeQDw7/Eg9gPcLB4TDlXnoe6M+R8jt5FJ7gFx
He6hzgOA//JY08o3OdWY8KibSZ2HOjPmf4zcRt4nrr/r3HTqPAB4NY/TxGPD
/uoc1BnzP0ZoHxPc3cK6+7tbRZ0HAK/lMdnKtznV+PA7N706D3VlzP8Yvn1s
I667E9U5ADA0j93FY8Ru6hzUFfM/RmgftwrrLb7vzanOAYCheUxn5Rudapz4
rXEmyFjrjvkfQ7WNzcT19l51DgCMzGNlK9/qVGPFDuoc1BHzP4ZpG9cL62ya
uvwA2udxknC8uMNYIzyWOmP+x2DtYj1xna2jzgGA9nnM714SjhnvUuegbpj/
MUS7OEtYX1epyw9g9Ez7DuA76vLXDfM/BmkTs7rnhfW1kToHAEbPY2Er93Mr
xo34dzkjdHT1xfyPgW1iJ2FdXa8uP4Cx8/iacPzgPKDR1RXzPwa2iSuEdbWZ
uvwAxs5jKdPtBbhBXf46Yf7HgPawkPuHqJ5uVZcfwPh5nCsc75dRl78umP8x
oD18WFhP26jLD2D8PJY33d1An1GXvy6Y/zGgPdwhqqO4Y2CCuvwAOsPjEtFY
EncCcBZAe3XE/I++trCKsI7epy4/gM7xWE04nmygLn8dMP+jX1s4XlQ/D7hJ
6vID6CyPH4nGlDPVZa8D5n+02sEk95iofvZWlx9A53msIxpTnnOzqMufHfM/
Wu3gnaK6iTv+ZlCXH0B3eFwtGlt2VJc9O+Z/tNrBt0V183l12QF0j8duorHl
cnXZs2P+h8ecpru3YwV1+QF0j8cc7i+CsSXOIFpAXf7MmP/hsaeoXm5Slx1A
93l8SzTGHKoue2bM//C4SlQvB6rLDqD7PN4hGmNuUZc9M+b/ZvOYxb0iqJO/
uSnq8gPoPo+JVtb6Ksb/edXlz4r5v9k8NhHVyffUZQdQHY/jRGPNduqyZ8X8
32wex4jqZGt12QFUx+ONorHmNHXZs2L+bzaPGwX18bSbUV12ANXyuF0w3tyn
LndWzP/NZWXfn+Ke7q+oyw6geh6HiuaARdRlz4j5v7k8NhfVx1rqsgOonscC
pnnm2FVd9oyY/5vL4wRBXfxWXW4AOh6XC8ads9Xlzoj5v7lM8y3u4+pyA9Dx
eK9g3HlEXe6MmP+byWOK+6egLlZUlx2Ajsfc7h+CsWdpddmzYf5vJo9tBfXw
uJtOXXYAWh43CcaffdTlzob5v5k8ThXUw7fV5Qag5/EFwfhzgbrc2TD/N5PH
bwX1sLe63AD0THMfwBPG+8eB9cD83zAerxfVA9/fAMQYNJuVO0CqHoNWUpc9
E+b/5vF4n6AOWH8L4D88rhWMQwepy50J83/zeJwlqAP23wL4D49PC8Yh7h17
dR0w/zeMx92COni/utwA8vDYUDAOPaEudybM/83iMcn9VVAHi6rLDiAPj5nc
y4KxaLK67Fkw/zeLx9KC/N+vLjeAfDyuEoxHa6vLnQXzf7N4vEuQ/6+pyw0g
H48jBeMR3yL/m3/m/wYxzf2bO6rLDSAfj7cIxqNj1OXOgvm/WTxOF+R/AXW5
AeTjMb17seLx6FJ1ubNg/m8Wj19UnPtH1WUGkJfH/1U8Jt2lLnMWzP/N4vFY
xbm/Sl1mAHl5fLPiMekVN1Fd7gyY/5vDYy5B7k9VlxtAXh4fF4xLS6nLnQHz
f3N4rCnIPedtAhiSxzaCcemd6nJnwPzfHB67CHL/DnW5AeTlsaJgXDpYXe4M
mP+bw+Ozgtwvri43gLysnAP4j4rHpa+qy50B839zeFxccd5fchPU5QaQm8cD
FY9N09RlzoD5vzk87qw477erywwgP48fVTw2sS/5X8z/TeExwaq/a+NCdbkB
5OdxvGBemFNdbjXm/2bwWEKQ90+ryw0gP499BOPT6upyqzH/N4Np7treSV1u
APl5rC8Yn7ZTl1uN+b8ZPLYQ5L3xv68BjMxjAcH4tJe63GrM/83gsbMg73Oo
yw2gHjz+XPH4dIi6zGrM/83gsV/FOX9KXWYA9eFxR8Vj1FHqMqsx/zeDx+EV
5/whdZkB1IfHtRWPUcepy6zG/N8MHp+qOOd3qMsMoD48rqh4jDpNXWY15v9m
8Dih4pxfqy4zgPqw6s8nPU9dZjXm/2bwOKPinP9YXWYA9eFxVsVj1A/UZVZj
/m8GjwsqzvlF6jIDqA+Pkyoeo36uLrMa838zWPXna5+lLjOA+rDq7ye9WV1m
Neb/ZvC4puKcn6QuM4D68PhoxWPUveoyqzH/N4PHbRXn/LPqMgOoD48PVjxG
/UldZjXm/2aw6u/XPkJdZgD14bFrxWPUi+oyqzH/N4PHExXn/IPqMgOoD4+t
BHPDBHW5xTln/m8Aj5crzvmu6jIDqA+PtwnmhjnV5RbnnPm/x3lML8j5Vupy
A6gPj7UF49Tr1eUW55z5v8d5zCPI+SbqcgOoD48VBePUsupyi3PO/N/jPOZi
/geQmccbmf8rzznzf4/zmCTI+ZbqcgOoD491BOMU7//18zPzf/fr+S8V53wX
dZkB1IfH2wVzA+v/9PMz83/36/mxinP+AXWZAdSHxzaCuWGiutzinDP/N4DH
fRXnnPN/ALTNY7eKx6i/qMusxvzfDB63VJzzz6jLDKA+PA6seIx6TF1mNeb/
ZvD4RcU5P1FdZgD14fGxiseo+9RlVmP+bwaPyyrO+dfVZQZQHx7HVDxG3aIu
sxrzfzN4nF9xzi9SlxlAfXicXPEY9Qt1mdWY/5vB4/SKc/5jdZkB1IfH2RWP
UZepy6zG/N8MHsdXnPNfqssMoD48Lq14jDpfXWY15v9m8Di64pzfri4zgPrw
+EnFY9Tp6jKrMf83g8dhFef8QXWZAdSHx/UVj1FfUpdZjfm/GTz2qTjnT6nL
DKA+PO6qeIz6pLrMasz/zeDxXkHeZ1eXG0B+HtNZ9XeUHKoutxrzfzN4bC7I
+2rqcgPIz2NRwfi0t7rcasz/zeCxniDv71WXG0B+Hm8TjE87qMutxvzfDB6v
F+T9aHW5AeTncYBgfHqzutxqzP/NYOX72gsV5/0CdbkB5GfVn/0X5laXW435
vzk8bq4477epywwgP4+fVTw2Pa4ucwbM/83hcV7FeX/JTVCXG0BuHo9UPDZd
rS5zBsz/zeFxlCD3i6nLDSAvj9kF49LX1OXOgPm/OTx2EOT+7epyA8jLYzXB
uHSYutwZMP83h8eqgtwfqC43gLxMczbZ5upyZ8D83xweswly/xV1uQHkZdXf
TRaWVpc7A+b/ZrHq19lcqS4zgLw8Lqh4TPqbm6QudwbM/81i1e+z+aO6zADy
8rit4jHpN+oyZ8H83ywepwjyP5+63ADy8ZjF/bXi8ei76nJnwfzfLB4Hkn8A
GXhsIhiPPq8udxbM/83i8XZB/r+qLjeAfDyOEYxHu6vLnQXzf7N4LC7I/73q
cgPIx+MGwXj0FnW5s2D+bxaPCVbO5a26DhZWlx1AHh5zur8LxqIp6rJnwfzf
PB63C+pgF3W5AeTh8S7BOPS0utyZMP83j8epgjo4S11uAHl4fEkwDv1QXe5M
RPN/1ffQs97j1XW+raDOf68uN4A8PG4VjEOHqsudScyNgrn/0Yr/Tc6gf3Wd
T3H/FPS9pdRlB6DnMVk0Bq2qLnsmVv1+8Jj7f1vxv/lxdZ6zMc0agD3V5Qag
57G1YPx52k1Qlz2TmBsrroOY+2+q+N88Rp3nbDxOEPS/89TlBqDncbJg/LlE
Xe5sPI6tuA5udtMq/jdPVuc5G4/NBf3vT+pyA9DzuFsw/nxAXe5srPrfYT93
P6j43zxbnedsTLf3dnl12QHoeCwgGHfCcuqyZxNzY8V1EHP/eRX/m7z3Gbzu
bxT0wSPU5Qag47GvYNx5VF3ujDwurbgeYu4/reJ/8yfqPGdkmrO371aXG4CO
x3WCcedb6nJnFHNjxfUQc/9xFf+b16vznJFp7t4Ka6jLDqB6Hm8QjTl7qMue
UcyNFddDzP1HVfxvPqjOc0ZW7t5+RdAXv6wuO4DqeXxKNP8voS57Rh4PVVwP
MfcfUvG/+Q83szrXGVlZj1l1X3zSzaAuO4DqeEznHhSMNw+py55RzIlW/RlM
MffvJWgDK6nznZHHVEFdhPeoyw6gOh5vFY01Z6rLnpHHyoK6iLl/M8G/u606
3xl5rCvqk5eqyw6gOh5fE401O6nLnpHHdoK6iDsfFWtAPqHOd0YeM7gXBfXx
VzdZXX4A3ecxk/uzaP5fUF3+jEzz7ndpN7E1/lf577L/Y+h2UPV5TH04jwto
ANM8a4Y71WXPyqo/hyfm/Emtf/uuiv/tm9X5zspjB1HfvFFddgDd53GZaIzh
vLGh6+SWiuvi7n7/dtXnDsU77unUOc/IyjpQ1bu5ZdXlB9A9HvO5vwnGlljb
vrC6/BlZ2YtR9Xff7/T79xVnzy2izntWplub8zl12QF0j8dBorHlZ+qyZ+Wx
qKA+ju337+8q+Pffqc57Vqbbm/OIm15dfgCdZ+U58w7R2LKLuvxZWVmHX3V9
7Nbv319L8O9/QZ33rEx3NkfYXV1+AJ1nmnvGQ7zbnk1d/qys+jP4w9r9/v15
BP/+r9R5z8zjaFFfvddNVJcfQGd53CAaU85Rlz0zq37tX5g84G94ouJ/P84B
nkud+6xMdzdH2FFdfgCd47GxcDzZWF3+rKw8e1d97u+Tg/wd1wjaxbvV+c/M
41pRf73T2J8B9AyPaaKxJNYUTVCXPyuPLQV18stB/g7FmvMT1PnPzGMfUZ8N
3AkA9ACPdYTjyLHq8mfm8WVBnbzmDgaPfQV/x+3q/GfmMbd7WdRvWZ8B9ACP
Hwrn/+XV5c/M49eCOtl/kL9jacHfEd89Xqeug8w8LhL23beryw9g7DxWFY4f
N6nLn5mVs5gU9TLoOW9WvtVU/bdsra6HzEy3Zydcoy4/gLHzuFg4fhyoLn9m
HtsL6uSPw/w9Zwv+njPU9ZCZx/RW/d6M/tZX5wDA6HksZ9WvLe8TZwxPUecg
M9F8+81h/p5dBX9PnHU/s7ouMvM4UdSHw0/U5Qcweh7nCMeN76vLn5nHrO4F
Qb3sNszftIiorbDffPi28kZhPw5rqnMAoH0eS7i/C8eMLdQ5yMxjZ1G9LDbC
33Wf4G+6XF0f2Znuzs7wU3X5AbTP41zheBH3ybPnf/j6uUJQLw+08XedJvi7
4izABdV1kpnH2sL+HLZT5wDAyDw2EI8VO6tzkFnMda05r+p6+Vobf5tiTWL4
sLpesvO4Utin/+BmV+cAwNCsrBe+SzhO3G/cHzJSHR0mqpsRv7Obbk/inep6
yc5jI2G/DsepcwBgaB6Hi8eIvdQ5yM7jdlHdLNDm33en6O9bTV032XlcL+zb
sadnRXUOALyWx8KmWVPeJ86PmUGdh8w8VhbVzV2j+BtPEP2NJ6rrJzuPdwn7
d7jauBsISMfjEvHYwHk/I9fRl0R1c9Io/sa1RH/jc25udR1l53GruJ/vos4B
gP/yeId4THjMOMdlpDqay8p5N4r6WWeUf+u9or9zqrqesvPYNkFfn0udBwD/
Hg9mMs2+7f4+os5Ddh5HiurmvjH8rZ8Q/a1PudnUdZWZxwT3G3F/P0WdBwD/
Hg+OEo8FTxt7g0aqo9nck6L6mTqGv3dx050dfZi6vrIzzVnN/cX+1Tep8wA0
mceS7iXxWPBJdR6yM92ev7DEGP/mq0V/75/cTOo6y8xjkntI3O9vNM75AmQ8
figeA55386jzkJnHzK05TVE/V4/j795T2K4+oK637Dz2Fff9cJA6D0ATebw3
Qf//vDoP2Xl8UFg/e47j7471ii+L/u7fuenVdZeZx4zuj+L+/4pxbgNQKY+l
rTx7K/v+X9x86lxk5jGDe1hUP/FdaFzrtD0uELavIe8qxH/q50PiMSDEmZ9z
qnMBNIGV9f63Jej3/6vORXamfYd+QQf+fuV5M/G7ib0Aw9eP+rzvPheqcwE0
gWnuaBso1rLz3X/4eprDtO9nN+tAGWKd2ePCMnxBXY/Zmf6+rz77qXMB9DKP
HRP087C7OhfZme4c3RBntEzqUDn+V1iOOHN+BXVdZmfa+777xFqRVdS5AHqR
5fjmH64zzgAfqa7e6P4urKPjO1iWJcVl4cz5ketoftOdLdlfnBvJWSBAB1me
b/4xD/Abf/i6ms5dK66jMe35H6ZM54jb3a7qes3O44AE40M4X50LoJdYjm/+
gTvaRq6r3cV1dHYXyrSc6c4DDLEGgbuBhq+jie6WBGNE2FudD6AXWJ5v/nGG
Dft8hq+redwTwjqKc1mX7VLZLhK3v1PV9Zudx5tN+zutT+w9faM6H0CdWZ5v
/mEndT6yM/17mq7tw/JYRVy2+G2zlrqOs/M4PcFYEe5xc6jzAdSRx6yW45t/
mKbOR3Ye65j+2WvlLpfxMnH5HjTunh2pjiab7q6pga50M6pzAtSJlXM9fpSg
/4bYg7W8OieZecxt5cxaZT19v4Jyrp2gPV6sru/sPPZIUE99LjTuCQLaYmX9
uHq9dX+cwTJynX03QT2tWVFZr0xQ1g+q6zwz0+9BGegUdU6AOvA4LkF/7fOI
cQbrSPWV4Qz2n1RY3o0SlJd7Z0aup5VNe27DQFPVOQEy8/hwgn7a3zbqnGTm
sYb7a4J6Wq/icl+XoMxx7wzry4avJ+XZjYPZR50TICOPXRL0z/6uUOckMyv3
4z6YoJ6uEZR9kwTlDuO+46iXeczufpugnvrEHo6t1HkBMvF4p5V1dur+2SfO
Eu3oGXK9xuOSBPUUNhKV/+IEZQ/7q9tCZla+A7yUoJ76xD0BG6jzAmRgZU31
XxL0y/62VuclM48DE9RRkD3/eizsXkiQg/jdPO67DnuZxz4J6qm/eL7o6l5V
IDsr56o+naA/9vdldV4y89jCcqyrinOhFhLn4rAEeQjx+3kdddvIzOP8BPXU
X5wnyjtGNJKV56eHE/TD/m4yzusYrs7WtTzvUg9JkI9J7s4EuQjPuBXVOcnK
ylqAexPUU3+xhnNxdW6AKnksYuV8THX/6y/eyS2pzk1WMbe05hh1PYU73CR1
Tlp5eWuCfPT5o1tMnZOsrJzh/HKCeurvUeOuADSElXf+2Z77A3v9hq6zRd0f
EtRRn3XVORmQn28kyEmfWO8+rzonWXnsl6COBnrWKt7DClTNYy33VIL+NhDn
cw1dZ69zv0lQR32+oc7JIDma1/K8GwnxHWt2dV6y8rggQR0NFO8ltlTnBugG
j03diwn62UA3G9/8h6qzuIPphgR11Cfm2JTPth77JshPf9OM3wBD1dUc7r4E
dTRQnA+wlzo/QCd57Gy59vf3ec4tpc5PRlbm/p8kqKP+9lPnZZh8TXA3JshR
f/EeIOXvJTWPVS3fWoA+R6rzA3SCxyGmvxd2KNup85ORlXf+2eayX1nye9Ss
rC97JUGu+os17+wzG7y+9k9QP0M5OXt7B4bjcWyCfjSUr6jzk5HHYpZvb0bc
MVCL+24sz9lI/bHGfOj6ujBB/Qwl1inMoM4RMBpW9kV/PUH/GcotbiZ1nrLx
WMnKHjJ1/Qwk3+s/yjxemiBnA7HGfPC6irUAme4IGOhnxjoO1ITHzO57CfrN
UGKf/xvUecrGyj72ZxPUz0Dfd9Op8zPKXM7tHkqQu4Hie/d71PnJxmMJK+fx
qetnKHe5FdR5AoYT86qVZ2t1fxlu/FtfnadsYk6wPOf69fd7N486P2PM6ZqW
427kgeLs5g+p85ONlXuC/pygfoYSZzzvrs4TMBiP7a2sp1f3k6Fw9+bg9XZw
Kzfq+hko9ousrc7POHN7SII8DiW+UcylzlEmHhtY3j0Bfc5xs6lzBQSPmdxX
EvSLkeyjzlUmVt5RfydBvQzlcHWOOpDj6ax8v1DncigPuNXVecrEY2vL+Xu4
vziPi7seIGX53/f3marOVSYea1jO79N9fmg1++Y/TK7nsfIdQ53TocR+xQPU
ecrE8p3lNJj4HrCnOldoJsv/vr8P+/xeXW8HWc7v0n0eca9T56nDOV/Hcp5/
1d/Fbk51rrLwOCpBnbTjW8b3AFTE6vO+P1xknKHRV29zWc59af3F2rS3qnPV
pfx/OEF+RxLfA9ZU5yoLq884F+d1cL4Dusrq874/XGmc699Xb3Hv0oMJ6mQk
H1Xnqsv1cGqCHI8kvn2f4uZW50vNypnOFyWok3bE/h3WOKErPHa0erzvD/Eb
ZQ51ztSsfHs+1fKvZwpnqvNVQX3EfHJxgly343G3q/XIOoxx1NmM7qoE9dGu
XxhnBaBDPJZyP0rQrtt1v5tPnTdxncW68/e7JxLURzu+6yaq81ZR3dRtPrnG
raTOm7jO4ozAurz3DLHW5AvGugCMkZXv/J+0/Pth+4szvJZU505cbyu1xmx1
XbTrajezOm8V11HMJ7cmyH27Yj453hp8Dq3H/FaeLdR1MRoPu63VuUO9eGxa
w7Ye3yZWUedOWGezuy9Z/nXm/d1uDT2Dxuo5n8TdEHtZQ++ksXJO8AMJ6mG0
LjfuOccIPBax/GvEBxPndq6nzp+ozmZwe7o/JKiH0XjQLaDOn7ju4tvaYwnq
YrRij2bccziLOoeCOovfbXV6d9Mn3uMeZdx7hgE8pncfcS8maKejFe/8G/fc
b+WepQ9aecenroPRijmPO5hKPa5q9VlXO1CsETzCGrbW1mNO9/ME+R+L+9w7
1DlEDh4bursTtMuxtuVGfe/3mM0dZrnvKxtOzHWrqvOYSasPvpKgbsbqGfcp
N1mdywrrLNZH1fFdaZ/Yh7KsOo+Qtd+l3XkJ2uFY3WwNWudv5fyeI91TCXI/
VjHHbajOZUYeW1i91toO5gUrZwc04gwhj4nu9AR5H6vYF3yhW1mdS1TWZle0
Mu/XYU/4UOJsn0a8c7TyfvgEy303aTtibttCnc/MrNw/V/d67hNn0n3cLarO
awX19pkE+R6vH7g3q3OJrrXR1a3c9/bPBG1tPOL3ak+f6+fxene4uzNBvjsh
3vnz3N9e3a9i9f22M5gYb6a53ayHf7N7HGD1H1vDT90G6nyiY+1yXffjBO2q
E+LdYk+e52/lu/4urf5X53czAzVyfeY428KSVta2qOuu0+LOuvPd+9xC6jx3
od52sNx3a43GL92m6pxizG1xEytnQarbUadMVee0C3W0oNvJnWv13Hsxktjf
3qj1mR1sG/NZvc6cG4v4RhC/6be2Hlk7aGXcfSFBbjvlJreVNfwc6Dqwcu7r
u92NCdpNp8SzcE/ca2HlPP4t3Zetvnsu2hVz1/zqnNeZlXMCr0xQl1X4Z6vN
fNFt5ha1ms45Vr611uXs7XbFeBX7jhZU5xevaW8LuEPdrxO0k06KNWNbqfM7
xjqJ32ILWzlL8fNWfkf30nv94VxlPfytt+J2FPcF1OUOuk6L7wVx1s633dHu
ve5NdWhbHsu4hxLksNNiDLvCynvLWdV5bior57/E96a4m+fvCdpFpz3r1lfn
uY16iHN3V7NyP2LclxDfN+M5phff57cj9hX39PpMQRuLewPrchd9VeIs4vht
EPdH/NBd4M6wslfm01bWz+5v5TfD+lbOWpy+4nqbbGVdvTpX3fK8+4bbyHp0
XVYmVp4p3+q+Zr2zT2gwsbe/0vOqrZyBGGPE+lbGjBg7YgyJsSTGlBhb4jkk
xpoYc2KOr9uZu90Wdw0zDnSvjR5ivbO+TCHmq3iXsotVdOeUlTE73pvX6V6O
sYhzSI9xy6n7Sa+xsh44ni3rePfEaJ1sFT0/WnmHEmNBjAnPJyh7XcXYdqi6
nzSBx5vd7xLUed3Fb/e4y2hSRfW2lvt9gnJX4VdW9kMuou4vdWXlm360zzrd
5Toe8T5jm4pyO6mVW57fxy/GtLXV/aVJrKwj/V6Cuu8F11lF54i26u37Ccpc
pdjHeprbzs2r7jtZWflWFPss4vm319eGDxRr4yrZJ2ZlX9V1CcrcC+LbZk/s
26oj43tAp8Rv2BUrqrP4HnBoQ+st9njcYeV76uZuTnUfEvbd2NvzLit3tt9q
vXF21FicZNW974+zj5vyDq6b4n1/fNOs5f6sXmLle8BDCdpE3cW7wMruoza+
44RYt36D+5zb2CpakyHqp7NYORvic60y9+Ka/dGI9f1bV5j/+J7C+/7xi99P
a6n7E17Vtud2303QNuouxuXK9q4Y33EGivvB4lk49nLEfZKxxzDOUki/37Nf
ncbd0GtYOeMy7oWI/VBxjnsT3/cMJdaHLFFhncQe6hsSlLvu4tvlPOo+hiHb
+cHGODNeh1NvKT1q5R6Jr1r57hVnRL3BKlq/OaC+Yj/uElbOdvlQ62+a1vob
1XnK7kQ3Q8X1dXiCctdZjE3xzZL3/clZOYviVwnaTF09Y4LfuB5rGt9xxiLG
ptgXN9RZEPEeIcb//dzOVu7Z3qiV73i3sKGVM3Njz/c+Vr5rxllTx1u52znO
c7nMyln6sec71jPW/Z5uhXjfv6WgX8U7tmcSlL+u4iyG1dXzGkbV5uP5ZH/a
/Zh9QlRv8R0nznZp6low9KY4o3AxUZ/6RILy11HMHTGHcJ5PTVnZ63JOgrZU
N7eI621tK8+z6jwA4xFrxSp/5h/Ql3r9DrVuiDM92avbIzzWs967G6TbpGfX
eEx0B7nnEuQCGI34JhNnQUrvh/BYJEEu6uR29xb1fIWu9IU43zq+g/bS3bTd
tLm6zlr1FneEn58gH0A74r7SZdX9ptV3Nk+QjzqIZ4xYx1r5WlpU3ifiN/Gl
Cdpcdnur62pAvf0/d0+CvACDifu4dlD3kwF9Zu8EecnuW1bhuSfIweNtxjmY
w5mqrqNB6mwG93Er9yKr8wOEOMco9kqkO6PBY2qC/GQ1za2nriPI+0jshboy
QXvM5sPquhmmzha33r5XGPUQdxOtpO4Pw/STDyfIUTaxF4Nv/HgVK2vOL0vQ
PrPYWV0nbdRZ7GVv+hnCqN7jbldLfh6MlfMe1LnKIPYTxzffN6nrBLl5rGLl
Puym70HfUF0XbdZXnCsfd8Nz1gO67UUr9xXNrW73bfaNDRPkTOkf7jy3grou
UC8ey1o5O6CJ95TE9/Va3UVj5T65j7onEuQPvSXWh8e9RVPU7XyUfWJma+Za
mbif7+tuaXUdoN6snHMe63seS9Cuq/I9dd7HUV/xPiD28nDXGcbraStr6Grx
vD9Ef2jS/Vpx/8QX3aLqvKO3eExy77SyF/2lBG29m7ZV57sD9RV3nsV59g8m
yCfqJX7rx1khs6vbcQf6wbYJ8tlNMRbHmPwON1Gdb/Q+K++ad3c/t95bJ3CT
JV/XNMq6it9tu7jfJMgtcnvEHWg1+/Y1QvufzkqfVue2k2LMjfuo9nBzqnOM
5vJY1H3MeuNsmuhXG6hz2qV6ijuh4lmIewUw0INWzsqZUd1Ou9T2N7DeeE6J
uyenusXVOQUG8ljDHWdljqljfztancOK6uld7voE+YZW/GbfxRpw7quVO53V
+R6LuLflRLeOOodAuzxe57Z2p1g93j1fbD303r/NOornonOt7OtS5x/ViLXh
cc5H9M3G3O1q5TvAxQnyP5J73Vfd9m4+dd6ATvBYyO3kzrR8Z9bEb5SefwYa
pm5mt3KeS5wDWcf3NhjZzVbuk2zsnGJlLcwpCeqiv4es7NWLs4per84RUAWP
Jd2e7itW5h3FfrU4M2dPdS4ysXI/VJwjcHeCsRHjE+v5jnXLq9tVJlbGHcV5
WVEfP7PyGyTWTy+hzgWQhZXn0NXcjla+133bylqCTr+fjv9/sU5hHnWZM7Oy
nuPL7skEcxna87z7hpX7Ihvzfn8MbXue1hjQjbHlFit78uJczhjLVnWzqcsM
1JGVb3fxXLqxe5/b333EfcbK2pivWzmz+MfuWne7lTXNMW/F2WXxTS32y5zq
NrMe2t9UUf6nd++28v30lQRzHF4tznm9wsr3tVnV7aVOrJwRuFlrbPhFa6x4
rjV2PNgaS2JMibElxpgYa2LMibEnxqAYi2JMirEpxqhGrSEC0BxWnpv2tXL3
WxPPhs4i1mnEc+ZhbkF1uwAANIfHnFb2Esb50LcZawe77bdWnlPjHIdancUP
AOhdMSe15qZTW3OVer6su9+7s6y8X2ZtOACgFmLOas1dZ7XmMvV8ml2cux/r
xvZyS6nrDwCATog5rTW3nd/6PdD07wVxX9t33AFuBWPtGACgATxmdatYOets
qvuWlbtank8wN3dK3M8Wa8gvdJ+2skZ/dePeFgAAXsPKeZEbWtlrcIL7kXvA
yl439Zw+ULzHeNj91J3cep5/m1vM2IMPAMC4eczUelce5xEMdRZEPGtf7n5p
rz4LYrizC+Jc/KetnE19p7vOyp76OPPgLHeS+6w7wn3Ayr0577Hy/oI99wAA
JOYxg5vcejZfwsqehZnUfxcAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAEAv+P/xVqdj
     "], {{0, 512}, {512, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSize->{50, Automatic},
   ImageSizeRaw->{512, 512},
   PlotRange->{{0, 512}, {0, 512}}]]],
 "\nThis button loads the main GeometricOptics package and all packages \
installed. Use it to start a working session with all GeometricOptics \
functions"
}], "Text"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzt3U+o5WUdx/E7Y5Q2LqKYWeSmXFgRzK5BSYQGK4L+oPaHcKOVpRFTjkEY
BBERFdGqdJVQtIgyIyRy08JF0CYkoX9UtpCKEiIyKnH09vxmzm3uXO+fc+75
/X7P8/t9Xg+8smbuvT3Pc8857y+O9/jqD3z85g8f3djYuOfy8h833/6pN509
e/u9t7ys/I/3nLnnro+cueNDbzvzyTs+csfZaz9wWfnFjaMXvKj8ZXNzEwhQ
1hXF24vPFg8Xf154ePFr3e9dUXufAEA/yrqu+G038h+g+5jrau8XADi8sl5c
fLE4t0T7t5xbfM6La+8fAFhdWd9dofs7fbf2/gGA1ZT13jXav+W9tc8BACyn
rBPFUz30v/saJ2qfBwA4WFn39dD+LffVPg8AcLCyHu+x/4/XPg8AsL+NCz/n
v8o/77/MzwN4XwAAaNjGhZ/176v9W7wnAAA0rKwPDtD/D9Y+FwCwt7LuHKD/
d9Y+FwCwN/0HgDz6DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNAHv0HgDz6
DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNAHv0HgDz6DwB59B8A8ug/AOTR
fwDIo/8AkEf/ASCP/gNAHv0HgDz6DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP
/gNAHv0HgDz6DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNAHv0HgDz6DwB5
9B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNAHv0HgDz6DwB59B8A8ug/AOTRfwDI
o/8AkEf/ASCP/gNAHv0HgDz6DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNA
Hv0HgDz6DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNAHv0HgDz6DwB59B8A
8ug/AOTRfwDIo/8AkEf/ASCP/gNAHv0HgDz6DwB59B8A8ug/AOTRfwDIo/8A
kEf/ASCP/gNAHv0HgDz6DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNAHv0H
gDz6DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNAHv0HgDz6DwB59B8A8ug/
AOTRfwDIo/8AkEf/ASCP/gNAHv0HgDz6DwB59B8A8ug/AOTRfwDIo/8AkEf/
ASCP/gNAHv0HgDz6DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNAHv0HgDz6
DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNAHv0HgDz6DwB59B8A8ug/AOTR
fwDIo/8AkEf/ASCP/gNAHv0HgDz6DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP
/gNAHv0HgDz6DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNAHv0HgDz6DwB5
9B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNAHv0HgDz6DwB59B8A8ug/AOTRfwDI
o/8AkEf/ASCP/gNAHv0HgDz6DwB59B8A8ug/AOTRfwDIo/8AkEf/ASCP/gNA
Hv0HgDz6DwB59B8A8ug/AOTRfwDIo/8AbFfWsdp7YJTvs/5z2MeO1wiYgbJu
LD5f/Lj42+J1/IniweLe4mTtPTLI913/WfaxcnLxWvDg4rVhc/Fa8cjitePG
2nsEllfWieJ7S7ymnyu+ULyk9p7p9fuv/xz0GHnJ4rl/bonvffdacqL2noH9
lfW+4qkVX9t/Wbyh9t7p7TGg/+z3+HjD4jm/yve/e015X+29A7sr65Y1Xt+f
Kd5Z+wz08jjQf/Z6bLxz8Vw/7OPgltpnAC5V1vGNi3/GbwYIpv/s8bhYt/2b
i9eY47XPAly0sdyf95sBAug/uzwm+mj/lu/VPg9wQVmne36tNwNMmP6z4/HQ
Z/u3nK59LuD88/szA7zemwEmSv/Z9lgYov2dz9Q+G3D+Of7QAM9vM8BE6T+L
x8FQ7e88VPt8wPnn+RMDPcfNABOk/wzc/s4Ttc8I6co6MvDz3AwwMfqfbYT2
b70mHKl9VkhX1mMDP9fNABOi/7lGan/nsdpnBc4/5x8Y4fluBpgI/c80Yvs7
D9Q+L3D+ef+xkZ7zZoAJ0P88I7e/87HaZwbOP/evLv5tBmDxeND/IBXa373W
XF373MAFZZ0d8flvBmiY/ueo0P7O2drnBi4q62jxUzMA+p+hUvu715ijtc8O
XKqsa4qnzQDZ9H/+KrW/e225pvbZgd2Vdb0ZIJv+z1vF9l9f++zA/swA2fR/
vrQfOIgZIJf+z5P2A8syA2TS//nRfmBVZoA8+j8v2g8clhkgi/7Ph/YD6zID
5ND/edB+oC9mgAz6P33aD/TNDDB/+j9t2g8MxQwwb/o/XdoPDM0MMF/6P03a
D4zFDDBP+j892g+MzQwwP/o/LdoP1GIGmBf9nw7tB2ozA8yH/k+D9gOtMAPM
g/63T/uB1pgBpk//26b9QKvMANOm/+3SfqB1ZoDp0v82aT8wFWaAadL/9mg/
MDVmgOnR/7ZoPzBVZoBp0f92aD8wdWaA6dD/Nmg/MBdmgGnQ//q0H5gbM0D7
9L/6/Ws/MEtmgLbpf9W7135g1swA7dL/aveu/UAEM0Cb9L/KnWs/EMUM0B79
H/2+tR+IZAZoi/6PetfaD0QzA7RD/0e7Z+0H2DQDtEL/R7lj7QfYxgxQn/4P
fr/aD7ALM0D1+9f/4e5W+wH2YQaoevf6P8y9aj/AEswA1e5d//u/U+0HWIEZ
oMqd63+/96n9AIdgBhj9vvW/v7vUfoA1mAFGvWv97+cetR+gB2aA0e5Z/9e/
Q+0H6JEZYJQ71v/17k/7AQZgBhj8fvX/8Hen/QADMgMMerf6f7h7036AEZgB
BrtX/V/9zrQfYERmgEHuVP9Xuy/tB6jADND7fer/8nel/QAVmQF6vUv9X+6e
tB+gAWaA3u5R/w++I+0HaIgZoJc71P/970f7ARpkBlj7/vR/77vRfoCGmQHW
ujv93/1etB9gAswAh743/X/hnWg/wISYAQ51Z/p/6X1oP8AEmQFWvi/9v3gX
2g8wYWaAle5K/ze1H2AuzABL31N8/7UfYF7MAEvdUXT/tR9gnswAB95PbP+1
H2DezAD73k1k/7UfIIMZYM97ieu/9gNkMQPseidR/dd+gExmgBfcR0z/tR8g
mxngkruI6L/2A9AxA/z/Hmbff+0HYDszwPz7r/0A7CZ9Bphz/7UfgP0kzwBl
vX+As72/gXNpPwAHSp0BynrtAOd6TeUzaT8AS0ucAco6Wvyzx/N0X+toxfNo
PwArC50BHu3xLI9WPIf2A3BoaTNAWXf3eI67K51B+wFYW9IMUNZlxc962H/3
NS6rsH/tB6A3YTPA64r/rLHv7nNfV2Hf2g9A78JmgLuK5w6x3+5z7qqwX+0H
YDBhM8C1xW9W2Gf3sddW2Kf2AzC4sBng8uIrB5z36cXHXF5hf9oPwGiSZoDF
ebv3Bnh9cVvx9YXbFr9W5Wf8tR+AGtJmgJZoPwA1mQGq3Ln2A1CdGWDUu9Z+
AJphBhjljrUfgOaYAQa9W+0HoFlmgEHuVPsBaJ4ZoNe71H4AJsMM0Msdaj8A
k2MGWOvutB+AyTIDHOrOtB+AyTMDrHRX2g/AbJgBlroj7QdgdswA+96N9gMw
W2aAXe9E+wGYPTPAJXeh/QDEMANoPwCZkmcA7QcgWeIMoP0AkDUDaD8AXJQw
A2g/ALzQnGcA7QeAvc1xBtB+ADjYnGYA7QeA5c1hBtB+AFjdlGcA7QeAw5vi
DKD9ALC+Kc0A2g8A/ZnCDKD9ANC/lmcA7QeA4bQ4A2g/AAyvpRlA+wFgPC3M
ANoPAOOrOQNoPwDUU3EG0H4AqKjSDKD9AFDZjGcA7QeAfcxwBtB+AFjCjGYA
7QeAFcxgBtB+ADiECc8A2g8Aa5jgDKD9ANCDCc0A2g8APZrADKD9ADCAhmcA
7QeAATU4A2g/AIygoRlA+wFgRA3MANoPABVUnAG0HwAqqjADaD8ANGDEGUD7
AaAhI8wA2g8ADRpwBtB+AGjYADOA9gPABPQ4A2g/AExIDzOA9gPABJV1qvj9
Idrffc6p2vsHAA6nrGPF14rnl+j+84uPPVZ73wDA+so6XfyweHKX7j+5+L3T
tfcJAAyjrOPFW4q3dv+99n4AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAJKUdaS4qngVANCsrtVH1mz+O4ovFz8p/lFsAgDN65rd
tbtr+DtW6H43O/y4gf0DAOvrmn7VAe2/tfh7A3sFAPrTtf3WPdp/UwP7AwCG
c9OO9h8v/tbAvgCA4XStP76t/99vYE8AwPC+v2j/dQ3sBQAYT9f+TzSwDwBg
PF37v93APgCA8XTt/3UD+wAAxtO1/7kG9gEAjMf7+gJAnkcb2AMAMK6vNrAH
AGBctzawBwBgPE8Xr2xgHwDAeD68eP+/2vsAAMbxyLb3/q+9FwBgeE8WV+k/
AMT4ZvGyHf/u39p7AgCG8afiXdu7P2D//1U8AgCM7uHiS8V7iqt36/6A/f/N
fv9/AEB9+g8AefQfAPLoPwDk0X8AyKP/AJBH/wEgj/4DQB79B4A8+g8AefQf
APLoPwDk0X8AyKP/AJBH/wEgj/4DQB79B4A8+g8AefQfAPLoPwDk0X8AyKP/
AJBH/wEgj/4DQB79B4A8+g8AefQfAPLoPwDk0X8AyKP/AJBH/wEgj/4DQB79
B4A8+g8AefQfAPLoPwDk0X8AyKP/AJBH/wFgHso6tsLH6j8ATFBZp4p7iweL
Py46/NfiR8Xnijfv87n6DwATUtZLi68Vzy/R5R8UJ3b5GvoPABNR1huL363Y
5qeKd+/4OvoPABNQ1uuL/67R6Ldv+1r6DwCNK+tFxc/XbPRfipcvvp7+A0Dj
yvpsT53+zuLr6T8ANKysVxTP9tjqU/oPAG0r6y09t/qM/gNA28r6dM+t/pb+
A0Dbynqo51b/Sv8BoG1l/bLnVj+n/wDQtq6tA/Ra/wGgYfoPAHn0HwDy6D8A
5NF/AMij/wCQR/8BII/+A0Ae/QeAPPoPAHn0HwDy6D8A5NF/AMij/wCQR/8B
II/+A0Ae/QeAPPoPAHkm0v9nFvsEAPrRtbV23wEAAAAAAAAAAAAAAAAAAAAA
gPU928AeAIDxdO3/RQP7AADG07X/Gw3sAwAYT9f+jzawDwBgPF37TzawDwBg
PCcX/17h+xvYCwAwvPu79i/6f2Xxhwb2BAAMp2v9lVv9X8wANxTPNbA3AKB/
XeNv2N7+HTOAvw8AAPPStX3X9u/4swD/PAAAzEPX9Cv3a/+OOaD7uYDu5wO6
nxHs3ifA+wQCQNu23tdv6+f7T+7V+f8BAxRldQ==
     "], {{0, 512}, {512, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSize->{50, Automatic},
   ImageSizeRaw->{512, 512},
   PlotRange->{{0, 512}, {0, 512}}]], "Input"],
 "\nThis button let\[CloseCurlyQuote]s you to select one or more packages to \
load. If you already loaded the main package with the ",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzt3Xm8rXP5//HLOcc8Ox1jZvE1ZgghmX5UkmQmIvNQyJBUOtJEJb5EIhKJ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     "], {{0, 512}, {512, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSize->{25, Automatic},
   ImageSizeRaw->{512, 512},
   PlotRange->{{0, 512}, {0, 512}}]]],
 " button you don\[CloseCurlyQuote]t need to use this one. \nIs opens a \
dialog window like the following"
}], "Text"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnXl0HcW958WWkwwHyAnbH5nJOyaBx4OQgTexmeGQc4aTCdjgxOQxDMkh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    "], {{0, 434}, {266, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{266, 434},
  PlotRange->{{0, 266}, {0, 434}}]], "Text"],

Cell["The two icons have the following meaning", "Text"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzdmltIo0cUx81VwQvSFWHRpZu2KbaCdIPijSJRixeyebCWtfq0i+nSF6tu
ZbdeSl/bN0npg1BaMGpbvD1sdSlSBIV4q3cXFKpFhFhTqaXqVuOl8/+Ys0xj
bBJz0W8fjt/nNzPn/M7MOfPNzBfdvY/KPlBGREQ8iGJ/yu4+NNbX3/3k3Xj2
z3s1Dz68X2OpLqn52HLfUp91T8UeGriomZyenvotR0dHyuPjYxX9f3h4GLG4
uKhrb28319bWfpafn9+XnJy8pFAo/mQmTiC4xzOUoQ7qog3akh7ohO6LMPkj
zI5C5J+YmEipq6tr0ev1v6BLPMiJVqvdg3B/ztRBW+iALtEf2AqFD6yfnvMP
Dg5mlpSUdDEOF/HExcX9XlBQ0NfU1PTIZrOZR0ZGDAsLC7q1tbXrENzjGcpQ
B3XRRvDJBZ3Q7clmoHJycvJ8DJaWlm6UlZV9TbaVSuU/JpOpg8XI7Y2NjXh/
daMN2kIHdJFe2IAtGhswBBpH7CrpaG1trWL95yD+qqqq1qmpqdfd6qtcLpea
iYrnkJLHIkSJZyhDHTE+IdAFneQPbMEmL1dcNM5gF9e9vT1VZWWllfoqNzf3
RxYfaW65eaE+Qxu0FX2Cbtgge7ANBpHJXx+cTmd0Tk7OY+hj881hS0tLHetL
il21v3q92YRO3MMGbMEmbIMBLP74QrGEdgaDYRh6YmNjHb29vUbeh8pQzo3Q
DRu4h03YBgNYuC9eY4xyen9/X5WVlTWA9gkJCb/Z7fZUlLO5XsPqhITfjUOy
hXvYBgNYwAQ2b7mP/MO1oqLiSz4Om2NjY2+SD6HmdxeyCQawgAlsIquH8ZRy
yWq1VqC+SqV61t/fn8f1eWwTJl8k22ABE9jAKDKTIHcQkysrK9ejo6OdqMvy
rPa8caD6oRBPeUwMYAIbGMHqXp/8MpvN36JeRkbGT+yZNHbhyAdf8gUsYAIb
GMEqstN1aGjIwOa5I41Gsz8+Pp7Cy/7TN+R7W1vbHTYXDmRnZw9kZmY+CYZA
F3RCt2hL6Gvpf7CBEaxgJh/oHVRYWPgDzyMrLzuTE/QsLy+v95x1YcAC3d7s
gxF1wcx9lnyYnp5+ja0HDuDn3NzcTf6ePROnNNc5HI54NrcX9fT0lHR3dwdF
oAs6oVu05T4meA5GsIIZ7FTO1s2fwr/S0tIu0b+rKMQGVjCDnc8FCp1ON4dn
HR0dpfD3vLlZHBe+3gu6eFun8blHAVYwgx0+sPXxy9jjsPeMc3NzM/a8Mb0q
QmxgBTPY4QP2l/AL+5qrHlPusQVmsNN+GvfNzc0Padwum9ObECOYwQ4fjEZj
H88NE6/j03gI+6Ogio9+SIxgBjt8SEpKeor70dHRt1Dm45o8lPnjVTcxghns
3IcdJsfz8/M3eT/7tLdge+uX1tfXrwVToNPHWJAYwQx28iEyMnIPZxoo+7+5
itYwFovlC61W+3dUVNRf7H20GwyBLuiEbtGWJyFGMIOd+/Ki+PFCxBXOKnme
35JznrN3ibR2tdlst1Em13mX1oiNjY2PeB1Zvge7urpMfF3S709+XKZ4Wpcs
Ly/fQK7ExMT8wdZecSiX4zqRjZFCr9fPwK/Ozk6TXNftKGtoaGjCs6Kiou/F
cbuKct4+CjIzM/Mq9ohqtfrZ7OzsK3Lc15J/xcXF34nndXI7Z6D3//Dw8C1W
Jp372O122Z37iFez2fwN/ExPT5fdORz57uFctAZlcjoXFf2yWq3vC+fUb3M9
sjinJqH3Rnl5+Vf0jY7F4xue4jVMPvj93YDHofQdZ3d3V81y5AnaJSYm/jo5
OZnCy8LiS6DfcXi/S9/Vtra2Ypkvw/zb5mM+jiGPr2B8VxN8kfRsb29HV1dX
f87eUe+EOraC/Z1TjLEwxE9IvzuLdvi8feFx4Hl1ab8DCIeE63cZgcYMrgcH
B4rV1dVL/53MRX2A7OzsRKamptrZeghnM0ee1oXh/t2Sn35IvrD81KSlpf3M
1wfbofwd2b9omL5o
     "], {{0, 50}, {50, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSizeRaw->{50, 50},
   PlotRange->{{0, 50}, {0, 50}}]], "Input"],
 "\nThis first button let\[CloseCurlyQuote]s you to select all available \
package from the list. If you want to manually select the packages to load, \
hit the CTRL key while clicking on items in the list. It\[CloseCurlyQuote]s \
recommended to load one package at time, however multiple packages can run at \
the same time."
}], "Text"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzNWmlLXFcYdhYTqXFM0tiqoyQukbSVVgSpmIK4fXAHS9E6gRKpDf1iNSlN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     "], {{0, 50}, {50, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSizeRaw->{50, 50},
   PlotRange->{{0, 50}, {0, 50}}]], "Input"],
 "\nThis other button clear all selected items. "
}], "Text"],

Cell["\<\
Once you have selected the package(s) you want to do load, click \
\[OpenCurlyDoubleQuote]Load\[CloseCurlyDoubleQuote] and the dialog box will \
disappear. Now, you are ready to use the functions defined in the package you \
have loaded. If you don\[CloseCurlyQuote]t know how to use them, you can use \
the default notebook that comes with each package. To open such notebook use \
the third button in the main palette\
\>", "Text"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJztWntIW1cYzzsxURsp1mSdr4ASRB1OswymjopsDBxox5yIwqp1xYFW7GAM
nDhh4lBkbNO/hsMJrggiuj98VHCoc7W2zdzwiY/6LKh5+MzLxH1fuKcEqbHR
q9ew/PHz6L3nnPv7fed7HM+94Xl3b37GYbFY90Tw4+atL2+Ult766iMp/PFx
8b3CO8UFtz8o/qLgTkHp23lcuPgmBR7g8PCQZbfbOdgitra2RAaDQQIQu4Bk
Z2dHgP1tNtuLsUyCaGhoaPhErVY/kEqlz/38/PS+vr7HQefv768NDAxcrK+v
z8SxFouFx7QORG5u7ve4NE4wAyzHwEwB+1laWlrexzmsViujWlpbW99DTnw+
f6+iouLu2NiYYnJyUj41NSWfnp6WHQXce21iYkKemZn5E44TCARbPT09aqa1
qFSqLh6PZy0vLy92Z9zBwQErNTX1N9QCvvZ8ZGRESV3nMqGD+BLY/zra02Qy
CdDfXQH68LHv7u4uH+zQjeMhXmZhjteZ0gI2vZ+YmPj79va2zynGc9bX1/2U
SuVD1BIWFqZZWVkJoLQ48gfkEdpxEq+1tbUrw8PDsd3d3fFdXV0JLwO5NzAw
EE3Gzc3NXQsODh5HLbGxsX/o9XoR0Um1bLoBduIRW1H24sBzffLz878LCAhY
O5K3XKKoqOgbMo9Go1HA+CW8npyc3L6xsSEE/2OZzWbMy7TC2fakfu3v7/MS
EhIeEG6hoaHT0dHRGgpPj8BxPSoqSkP6l5WVlZA5+/v73xCLxVq8LpPJpsLD
wx8DngKe0AWFQvE4Li7uz+zs7Pre3l4V0VJbW/spPjcoKOhZe3v7DdDFdeWD
MMbho5WVlZ8TLXV1dbnkfltb27sikUjrzrqeATaSZ8H+T9hstq2xsTGd+NkJ
ccQGLY58VFJS8jWph01NTWmkD9SX4MHBQfXQ0JAK2rfoBMSluqOjIyUnJ+dH
oqevr08FrR3qh3F+fl6G+fJV9kug1RFn+DvZC0A93Ons7HznInNtYWHht1wu
15aSknIf1uJQIpFsr66uBhGOrzIH9gPNPKgjrLS0tF9RC+zL1sFeMXjfaDQK
scacVIvcBc6Jc6NPwN4jjPgXthCbO+7qoGKFjX4I9ZCLNYiqh89g/tALWA+O
Vqv1hbj/OyIiYuQsOpzyHntzc1MMuWyQqof/jI6OKhcWFuQA2eLiYhCNkC0v
L1/FfIPP1+l0ErAj76w6EKQeLS0tXQ0JCfmXrDXEnQn81www0QGcDwH5cAvq
7V/V1dW3CQc6dFBaHDlsfHw8JDIy8pGPj49WKBTqIP71NMKALYfDMZJclZ6e
/jPuWenS4eRjGONsWHsp7LWuYEsnYM2ls7Oz8pqamjywlQH5Nzc3f0inDmct
F4GqqqoCWBt7TExMP906yByYy84LkHu56Me4Lhh/oMF6HjrOG4QjcsbahzXQ
03UgdxLzXh1eHV4dXh2XDV4dlwsv0wF1/QD+jzN4ug4C2Jte82QdWVlZP2Rk
ZPxiMpl4nqDhOB1Mc6JLB547XJZ3Y9718Orw6vDqcKWDOl/3iLrxf1gPfM+Z
lJTUube3x/fQev7ivIS8d8YzITyXP8+zJ5rOr/AdJ3dmZuY6dX5lPu13AJcB
yBnPE+Pj43vd/S6DSSAn5IYckStyRu6oAXW5+Z0M0yDf6DiA3KmYcfe7JUaB
3JAjckXOzhpO8R0Zk5AgR6fc5eD+H07Opp0=
     "], {{0, 50}, {50, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSizeRaw->{50, 50},
   PlotRange->{{0, 50}, {0, 50}}]]],
 "\nThis button opens a dialog window very similar to the previous one"
}], "Text"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJztnXmQHcWd55vLYS8BOMz1h3c9IWwYBowXZi2xS+CIJVgDAtbgYRhwyAYN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    "], {{0, 434}, {266, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->Automatic,
  ImageSizeRaw->{266, 434},
  PlotRange->{{0, 266}, {0, 434}}]], "Text"],

Cell["\<\
This time, you have to select one or more items from the list and then \
clicking \[OpenCurlyDoubleQuote]Open\[CloseCurlyDoubleQuote] it opens the \
notebooks related to selected packages. For examples, if you choose the first \
item \[OpenCurlyDoubleQuote]Baker Schmidt Camera CP\[CloseCurlyDoubleQuote] \
it opens the notebook like the following\
\>", "Text"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQmUVOWBsF3+M3PO951/+ebLTFaNcUliZjJx0GDGtFEBBcQFIgq4fC6Y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    "], {{0, 926}, {1354, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->{Automatic, Automatic},
  ImageSizeRaw->{1354, 926},
  PlotRange->{{0, 1354}, {0, 926}}]], "Text"],

Cell["\<\
If you scroll down the noteook, you will find some examples of how to use the \
function BakerSchmidtCameraCP, as shown in the following image\
\>", "Text"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQmYFdWB9339ZuZ53vf5tvnmnZn3nSSTidnMTCa+aDAxnRgRBcQFIwhu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    "], {{0, 926}, {1354, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->{Automatic, Automatic},
  ImageSizeRaw->{1354, 926},
  PlotRange->{{0, 1354}, {0, 926}}]], "Text"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJztWt9LWlEc9161n8psrHKsoEEsey3mKvbi4xgYU7a3GNVajE0lXYywFx+i
2saSXoLJ3B76BwbJIKSXnoboXsYehkKOrFFQMX9QmbrzcfcMGVn243av7Aof
z/Wc7znn8/l+v+fcw71eH7CZHrMymcxRRb5M/S8Mdnv/mFlDfty3Op4MW4ce
3bE+HxoesncNyEllBwcFQS6X4wXZbJY5ODhgCeRAJpNhUcfXfOfNPZ1OK0jJ
HmHDcjai1ASfF/7e2NhQB4PBNr/ff5PgVigUakPdUX2EjgH1/+bmpmpmZuah
wWD4WFdX9xNpWwjUoQ02sKXxETo2JOf/zj87O9vX1NT0vZB3Q0NDVKfTBQm+
1NfX/yhsg63b7e47bCwBNDA7OzsVRqPxPeXX3t4emJycfEJy6gZpqyR2sJVt
bW1VBQIBHWl7RmyC1J70/bC9vV2JsS5aC/KAzClPJBJKvV7vAx+lUhl3uVxP
k8nksTlPbJTE1kL6JNC3s7PzE/xx0XsaXZ8mk8kDHmq1et3n83Vx7fk9i3Ii
kHGA9vxeBRvYkj49KpVqHWP09va+4+JcdK/jQ4PX6zVycUgQPt2o29vbqwDn
EuIJWyWuFxYWeuRyeRJjzc3NPUAd0crrPsb5l4nH4xXNzc1fMfco+VANJx1v
f38/r2V8fNyGsSwWi4vToeBTB/XT/Pz8Xcyr1WrDWKNYK6fNa5pHy8vLHWS9
VdJ48ZxTeT+ZzWYvwzBZEgrnOfnvwtY29ffu7i7b0tLyDfFYWlrSc+eoM+cz
zmJn2avAAf48DliXKCORSKNCoUgSpMLh8FXUIc9LGYMvnMaP5DxxiTtjxPjO
45PA4/Hcs1qtbofD8dJut78qhpGRkdcoBwcH35JYpDUazbbNZnvDtRXtxyfA
Gdyh4d+zXLmCZdlsdXV10ul0uqanp0enpqZGURYD2icmJsaA42z5Ap0XnMEd
GqCltrb2VyqVOvF9TGiAM7jTmNTU1MSj0eg1Mew9pYByBGdwL9QRi8UaC+8T
YgblCM6SDuEh6RAXJB3igqRDXJB0iAuSDnFB0iEuSDrEBUmHuCDpEBf+Fx14
Xot3jQXvwkQJyvEwHWtra9rcn/cQLFeKGXmO4Ex1MAyTwfXq6uplTqvg/i4h
HvkSnMEdGqAFz89bW1tDOp3uczkBnMGde48REfpZ+VkBDSsrK1cWFxdv+/3+
boKeMkM3uEOD0HvoeQF7GP2vV7kCGn4D66gvJg==
     "], {{0, 50}, {50, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSizeRaw->{50, 50},
   PlotRange->{{0, 50}, {0, 50}}]]],
 "\nThis button is useful to check which packages are installed in your \
computer. Because chapters of the book can be downloaded separately, the \
corresponding packages are available separately too. So, use this button from \
the main palette to know which packages you have already installed. Here is \
an example where the packages \[OpenCurlyDoubleQuote]Fraunhofer\
\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]Triplet\
\[CloseCurlyDoubleQuote] from the chapter 9 of the book \
\[OpenCurlyDoubleQuote]Geometric Optics\[CloseCurlyDoubleQuote] are not \
installed."
}], "Text"],

Cell[BoxData[
 StyleBox[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJzsvQd0FVee7iu/mbvWvPXeWm/uTAcb59x35o6vu5tFu2kHwCDAxmCS2263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     "], {{0, 667}, {1032, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSize->{Automatic, Automatic},
   ImageSizeRaw->{1032, 667},
   PlotRange->{{0, 1032}, {0, 667}}], "Text"]], "Text"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJztWntIm1cUNw9jfCsqooOOOnADhytbfSvO+cKtKHbEKYkWXa2KYtsoFJ0v
6EDEF0Eok7HNP6Y0KpsZOJ9bq9Mouj+GL1CZQ9tpxEc1c42PGHdO+D4JaRKT
thovM/Dzy335nd899zzuvbmccfv6LaaFhUUBF/5cT78XIRSmF33qBAVefkFO
Vn7mzbj8wsysTGFgBgsq36fABhwdHV3gAmeKw8NDplKpZB0cHJwI7If9zS2z
JlQqFeNlZcJxOP4ccDj+PjEx8VZHR8eHra2tEWKx+CM9iMB2iUQSPjU1ddnc
8tNzCWBtbm7aJCYmNrFYrOfo0owFm83+Nzk5uVEul3PodYa6eVmYKj++E8Yd
ryPg8LUp8mtDIBDUv6Z5NdrmNPttbGxY9/b2XgVZlEwmUxUZGflwcHDwg+Hh
4SsjIyO+o6OjLwDrpVLplYGBgashISES0OEhjFXAuHfX1tbsVldXHeBpbyq2
trasNGQ0SjdtbW1R/v7+/e7u7n/Z2to+43A4B1ZWVv8sLCy4mTJ/09PTl2Bt
KXC8jY3NpouLyxPAU1Ph6ur6xMPDYz42NlY8Pj7urT3fugDzH6BrbfB4vK+w
fW9vj0P5X4PAftg/Li7u+1dZk9qws7OTzczMXDrJh/r4+DxiMBhHMA9LQqHw
C/jkFxUV3Z2dnX2DGmuUTmmbnpycfLO4uPhuSUlJPvyv26YC3n0HZcjIyKi2
trbeRi58Pl9E2TFb3/uBgwL6qsrKyoTm9pfauHbtmhjkUwUFBf2KZU1fpA1L
S8sD5CwSiTIhLrMVCgUXn8bqQYdeGDj+VYAy4Nynp6er/WZoaOhjjGv7+/sc
zX6Un1W/F+xSzaO2tjYby9hubj3QMqSmpn6LsoEffGygP8aaYx51dXVZ541H
WlraNyhbWFjYI9AFs7Gx8bPKysrsqqqqW9XV1Z/39PQE02NI4BEfH/8jyJem
y59BjBPv7OxYksAD4sjPfX19/hDf/nRwcJDZ29vLuFzuFs2lsLDwHgk8goOD
B7C8vr5uu7S05LK4uOgyPz/vCbpoh/xBCbH7bxJ4oJ3ryhsrKioKKJ0oSOGB
ZcwbMXfAmAu+meXt7T2O8SUgIOAnknhgHMS9J36n8ikVtjc3N39CGg86N0lJ
SXmAbWj3kKfbksQD4zc+ZTKZI3xWMC+EfdsDrCOJB+Yl+GxoaBBQ9n0IsTCQ
NB5g32zMQWCv1Iv2DXb+O+wX1Hk2STwQY2Njb8N+cxfry8vL79D9SeORl5d3
H+tgv7o9NzfnSemJSQIPOp5vb29zPT0953BNxcTEtFIc1LZPAg+Ic0NoAxgn
6JyqpaXlY+jDoOMJCTxgPziE5ejo6FbUBZ5ByOVyPE85PucigUdUVFQv5odg
E3Is5+bmfqktKwk8EhISfoD9UxZ+B1+1Bz7rHWzHXIsEHrCvpe3jF19f399w
Tfn5+fVjDNE+AzrPPPh8/ne0jwU51TEDYnmqLjnPOY8m6vxbibkU7JfWVlZW
HLFNez9CAg/Ywz7HNcXj8RqxXtd5HAk8OBzOPj67urqCKB4sEnngmvLy8vqD
zgk175po0OeJwCMbee7u7nJOOpM+bVAysAQCQRMdv0tLS4WG5hn8sVpn9fX1
N82tB20kJSUd+ys8N8c6fWfuzs7Os3h2Av55qL+/P1Aqlb6n787mLIDvx2d7
e3usm5vbIt4nhYeHSygOL9gFjZqamhuv877iNCCRSCLQLnTZNw3gaJGTk3Mf
dPfM3PJqw8nJ6alIJLphaD1pQB1PcE/S2dkZRt0xG7pnPlXg+xHd3d3By8vL
jkZyoHWiV1/mhqG1pIcLw9jfYJwFqDsas/8u4gL/b/wHGb7W2A==
     "], {{0, 50}, {50, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSizeRaw->{50, 50},
   PlotRange->{{0, 50}, {0, 50}}]]],
 "\nThis button open the main folder where GeometricOptics is installed. Is \
useful if you want to check your files or installed packages."
}], "Text"],

Cell["\<\
Finally, there are two additional buttons, useful to save examples from \
working session. When you run a function from a package, you may find \
interesting a special combination of input parameters getting a good optical \
system design. So you may want to save the input parameters set. These two \
buttons allow you to do that.\
\>", "Text"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJztmt9LU2EYx88PzxajaP4JofkDHI4RWzCMmReuGQjLgRe7mCOTbhZoECHk
/Be6EFIshSiZ1GroIpRGF+WlDCfzLogQRqztzp25s9PzjPPSe9MIVjtv+A6+
vuccXs/z/ex9n8eDz7kUvRe8IwmCMHcOfgSnHgzPzk49vGWHk1Bs7u5MbPr2
jdj96Znp2atRGS66DHWA6vU6StR1XUilUj6/3//SarUWJEmqi6LInMDbd5/P
92pjYyOA3tE3+tc0TVZVVZqYmFgBLB0FDDo5Zk20N+B5UygUzgOHhDyTk5NL
eB1YVep36mQ0ew1oL8QfeK3gODQ0lKrVakImk3HRDE6n88Pm5uZoNpvtz+fz
faDeo6MjU4Ue0At6SiaT1+HzmmZJJBKjwWBwBZlhvTSHw/GpXC7LuEYsC3JB
wD1FfHu93rc2m+0b2XOQO6M47+TkxApzJRZVqVQs4FHc2tryknyRZbkExxpw
6SDt4OCg28h9yezvvMlaSFincrlcr5E/jbzB+opccF6DvdhF5prttxkHjpg3
Rg3QqXrAOf5DDrx+enra0Q4183DW14P83d/b2+uPx+Pzi4uLj2BciP/9z4Jx
73mMRcdulQPrMKpYLF6w2+1f2/UchbEwJonfKgccN+4Bz2N2RVHK7eLAWBiT
9tDqviLn8GxzLRKJLEej0acwPvsXMu69jLGaeTnLeU4Ez8dyu+ouxuJ1l3Nw
Ds7BOcwX52BLnIMtcQ62xDnYEudgS5yDLXEOtsQ52BLnYEsUR9/vOPL5fBf2
EFnnwP+/Hx4e9ohUnxPGMuk77+zsXIG5jd6u2f3lJn1nK/Ikk8lh4Vff+YfH
40ljLx3ZAoHAC7O/7z9RqVRSBgcHP6Jv7DePjIwk1tbWbiIXeS9jbGzs+fb2
tjeXy/XAPuuGfWi60Afo8v7+ft/6+vr4wMDAZ8Nz472MdDrtrVarosvlek9f
N1QjwtwxU5QXjfizWCxVHEOh0BNjnaTj4+OLbrf7HZnD8ntLtMLh8GNVVUWS
+8gD6yKsrq6O43tAiqIUSS1jTLXOzs4vsAZLu7u7WJNI/1L4CUraIU0=
     "], {{0, 50}, {50, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSizeRaw->{50, 50},
   PlotRange->{{0, 50}, {0, 50}}]]],
 "\nThis button allows to save the input arguments of the latest computed \
example. Suppose you have computed a Houghton Camera examples and you want to \
save it. Click this button and it appears something like the following"
}], "Text"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQWUHdeZ73t833przX1v3rrz5k5iSMyQdWfG4zh+USLHIFmSbdmWZEhM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    "], {{0, 326}, {504, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->{Automatic, Automatic},
  ImageSizeRaw->{504, 326},
  PlotRange->{{0, 504}, {0, 326}}]], "Text"],

Cell["\<\
Choose a short description to add and the click Save button. The example will \
be saved in the list of examples for the Houghton\[CloseCurlyQuote]s Camera \
package. \
\>", "Text"],

Cell[TextData[{
 "\t",
 Cell[BoxData[
  GraphicsBox[
   TagBox[RasterBox[CompressedData["
1:eJztWl1IU1Ec3737ilE4zXqVcPkBijJCg2HMKcxmICxHQkJzZNKLgQYRQs7n
3kKEFFNBSia1GrqQWdJD+WjiZD4IQYYwZXNvuu/+fzkHzoOuj+3e3WiD3869
l7Pz+/12zv+c/7n3XnI8sN7jZTLZ4Bn4svY8ah4Y6Hl8Uwsntv7B+339vXev
9z/s7esduOqQw0U9gQKQSqUQXDqdlnk8HmNbW9srtVod5Hk+xXGc5ADa9o1G
4+u5uTkLakfdqD+ZTMqj0Sjf2dk5AbbSCPCQpsdSA6sN/LwNBoNnwQePfrq6
usbwOniNMr9J0TLffcBqofpA6xGWTU1NnkQiIVtZWdGzHurr6z/Oz8+b19fX
qwOBQBWgcmtrK69ADagFNbndbhN83rBeXC6X2Wq1TqBn6K9kbW3t50gkIsc+
kjIgFmQ4pqhug8HwTqPR/KBjDmLHjPUODw/VUJeXIo6OjlSgkVtYWDDQeJHL
5QdwnARfaUByY2NDR2Kfz/d/nqEveJyn/H5/JYmf47jB+RV9wXkCxmI5rZtv
vZl8YIlxQ+aANDMfFHz8gz7wejweV4iBTBr+9/6g6/7q6mq10+kcGhkZeQLl
sDP3n2HS9hBysdzZ+sB5GBEKhc5ptdrvYuVRyIWclD9bH3B83AbkY1qlUhkR
ywdyISerIdtxRc8ht7lmt9vHHQ7HCyinhABpexy5Mmn5n+OcAvJjuVjzLnIV
5t3MPjA/EyuvpXvWQn+cuA5yJD7w9zoR9oA65GK5s/VB7qfg/kVhNptnIc+P
KxSKOO7DhABpO45cyInc7BjLdh3c2dm5INYaSIGcrIZsxxXJc3lYn56WlJTs
lZaW7kMZEgKk7T3kQk6h1sFwOFwEKBYYRQLPu6LNY6dx5ao/aP4pNITsDykg
V/mVWOt5Ib/69f5jdHT0lslkWmptbfVB+UEIkLaXkCuTlr9dB3d3d89DvbiI
62AcOVkN2fig80ckEtGUlZV9FcsHciFnrvbn1AuW29vbF6enp28D7kxNTdmF
ALaNHMjFchfi/MQ2OBHvJ564Fhb6Q1oo+JAWCj6kBcZH1Wk+AoFAOb1HlW+9
mXzg2ri5uVnBMc85oYzQ584+n+8K1D1+titWfv6nAG1q9ON2u5tRM3nuHG5s
bPTi/Rb0ZrFYXub7//4dHBwcKOvq6j6Re0WplpYWF+QyN9AXfS+jvb19dnFx
0eD3+ytgnOnIfbe8AnUALq+trVXNzMx01NTUfCGaj9/L8Hq9hlgsxun1+iX2
OkGCAmMnn2C0JKk+lUoVw9Jmsz0n/cRDnl/U0NDwntaR8ntLLLq7u59Fo1GO
xj76gX6RTU5OduB7QEqlMkTnMokhUVxc/A36YGx5eRnnJLo/kv0EDFPFiw==

     "], {{0, 50}, {50, 0}}, {0, 255},
     ColorFunction->RGBColor],
    BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
    Selectable->False],
   DefaultBaseStyle->"ImageGraphics",
   ImageSizeRaw->{50, 50},
   PlotRange->{{0, 50}, {0, 50}}]]],
 "\nThis last button open a different dialog window that \
let\[CloseCurlyQuote]s you to choice which example to save, from the list of \
all examples in the current session. The following image shows an example of \
three examples available in the current session that can be saved."
}], "Text"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQd0FVeari3ff/1rzb3/nXVnzdwJnaa73e3Qt2d83YblsdXthG0Mbkds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    "], {{0, 422}, {578, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSizeRaw->Automatic,
  PlotRange->{{0, 578}, {0, 422}}]], "Text"],

Cell[TextData[{
 "Note that examples saved using this buttons are permanently saved into a \
file so to be available across ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " sessions. Currently there is no a function to manage saved examples, if \
you want to remove examples from a package you can either delete the file \
Examples.m in the folder \
\\GeometricOptics\\Packages\\[package_name]\\Examples\\ or edit it and remove \
only those examples you want to cancel."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["How to use the single package\[CloseCurlyQuote]s functionalities", \
"Title"],

Cell["\<\
Each package has its own function, that allows the design of an optical \
system. All packages share the same structure, tha means they define a main \
function (named like the package) doing calculations related to the specific \
optical system it addresses. Then they define a GUI function having the same \
package name with the suffix \[OpenCurlyDoubleQuote]InputPanel\
\[CloseCurlyDoubleQuote]. This function allows to use a small user interface \
to insert parameters for the specific package. Here is an example for the \
package WrightCamera.\
\>", "Text"],

Cell["Here are the input parameters", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "=", "600"}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"Ni", "=", "1.518722"}], ";"}], 
  RowBox[{"(*", "BK7", "*)"}]}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", "8"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[CapitalDelta]", "=", "750"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.5"}], ";"}]}], "Input"],

Cell["\<\
and here is the call to the package\[CloseCurlyQuote]s main function named \
WrightCamera\
\>", "Text"],

Cell[BoxData[
 RowBox[{"WrightCamera", "[", 
  RowBox[{
  "f", ",", "Ni", ",", "thick", ",", "diam", ",", "\[CapitalDelta]", ",", 
   "\[Theta]"}], "]"}]], "Input"],

Cell["\<\
Evaluating the above function, generates a new notebook in the form of a \
report, with input and outputs of the calculation, as shown in the image\
\>", "Text"],

Cell[BoxData[
 GraphicsBox[
  TagBox[RasterBox[CompressedData["
1:eJzsvQecVFWet1+M887sOPvfcWcc3V3DiGNYZ1dfcJBFxizBiIqCo/4NODM6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    "], {{0, 958}, {977, 0}}, {0, 255},
    ColorFunction->RGBColor],
   BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
   Selectable->False],
  DefaultBaseStyle->"ImageGraphics",
  ImageSize->{Automatic, Automatic},
  ImageSizeRaw->{977, 958},
  PlotRange->{{0, 977}, {0, 958}}]], "Input"],

Cell["\<\
Each package\[CloseCurlyQuote]s function accepts two additional parameters, \
as optional arguments:\
\>", "Text"],

Cell[TextData[{
 StyleBox["OutputType",
  FontWeight->"Bold"],
 ", can be one of the following values:"
}], "Text"],

Cell["\<\
\"Report\" generates a report as a new notebook, that can be saved in many \
formats, for instance PDF\
\>", "Item"],

Cell["\<\
\"Print\" prints results in the current position of the evaluating notebook\
\>", "Item"],

Cell["\<\
\"Basic\" returns the list of pairs, with the short description of the output \
and the corresponding value\
\>", "Item"],

Cell["\<\
\"Values\" returns only the list of output values, no descriptions\
\>", "Item"],

Cell[TextData[{
 StyleBox["OutputLevel",
  FontWeight->"Bold"],
 ",\tcan be one of the following values:"
}], "Text"],

Cell["\"Full\" gives both input parameters and output values", "Item"],

Cell["\"Minimal\" gives only output values", "Item"],

Cell["\<\
The following are examples of WrightCamera with the above options\
\>", "Text"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"WrightCamera", "[", 
   RowBox[{
   "f", ",", "Ni", ",", "thick", ",", "diam", ",", "\[CapitalDelta]", ",", 
    "\[Theta]", ",", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Wright's Camera\"\>", "Title",
       StripOnInput->False]},
     {
      StyleBox["\<\"Thu 1 Sep 2016 08:58:28\"\>", "Date",
       StripOnInput->False]},
     {
      StyleBox["\<\"WrightCamera\"\>", "Function",
       StripOnInput->False]},
     {
      InterpretationBox[
       StyleBox[
        GraphicsBox[{},
         BaselinePosition->Baseline,
         ImageSize->{10, 0}],
        CacheGraphics->False],
       Spacer[10]]},
     {
      StyleBox["\<\"Input parameters\"\>", "InputParameterTop",
       StripOnInput->False]},
     {
      TagBox[GridBox[{
         {"\<\"Focal length of the primary mirror\"\>", "\<\"f1\"\>", "600"},
         {"\<\"Refractive index of corrector\"\>", "\<\"Ni\"\>", "1.518722`"},
         {"\<\"List of thickness of the lenses\"\>", "\<\"thick\"\>", "8"},
         {"\<\"Diameter of the corrector\"\>", "\<\"diam\"\>", "200"},
         {"\<\"Distance between the corrector and the mirror\"\>", "\<\"\
\[CapitalDelta]\"\>", "750"},
         {"\<\"Field angle  in degree\"\>", "\<\"\[Theta]\"\>", "1.5`"}
        },
        AutoDelete->False,
        BaseStyle->{"InputParameterBottom"},
        FrameStyle->GrayLevel[0.85],
        GridBoxAlignment->{
         "Columns" -> {Left, Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1}}}],
       "Grid"]},
     {
      InterpretationBox[
       StyleBox[
        GraphicsBox[{},
         BaselinePosition->Baseline,
         ImageSize->{5, 0}],
        CacheGraphics->False],
       Spacer[5]]},
     {
      StyleBox["\<\"Output values\"\>", "OutputValueTop",
       StripOnInput->False]},
     {
      TagBox[GridBox[{
         {"\<\"Conic constant of mirror\"\>", "0.6`"},
         {"\<\"Corrector equation\"\>", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6.693409029342343`*^-6"}], " ", 
            SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"4.46253448825154`*^-10", " ", 
            SuperscriptBox["y", "4"]}]}]},
         {"\<\"Curvature radius of the second corrector surface\"\>", 
          RowBox[{"-", "74700.35042055801`"}]},
         {"\<\"Corrector sagitta:\"\>", 
          RowBox[{"-", "0.02509881131004733`"}]},
         {"\<\"Corrector plot\"\>", 
          GraphicsBox[{{{}, {}, 
             {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
              Opacity[1.], LineBox[CompressedData["
1:eJw12nk8VN/7APAKIRWRkuz7nlSSbQ5Z2hRm7syEhKwhKrKkQpaytEhmrj3Z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               "]]}}, {}, {}},
           AspectRatio->0.2,
           Axes->{True, True},
           AxesLabel->{None, None},
           AxesOrigin->{0, -0.025098811136086842`},
           DisplayFunction->Identity,
           Frame->{{False, False}, {False, False}},
           FrameLabel->{{None, None}, {None, None}},
           FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
           GridLines->{None, None},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImagePadding->All,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
             AbsolutePointSize[6], "ScalingFunctions" -> None, 
             "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (
                 Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                  2][#]& )[
                  Part[#, 1]], 
                 (
                 Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                  2][#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (
                 Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                  2][#]& )[
                  Part[#, 1]], 
                 (
                 Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                  2][#]& )[
                  Part[#, 2]]}& )}},
           PlotRange->{All, All},
           PlotRangeClipping->True,
           PlotRangePadding->{{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}},
           Ticks->{Automatic, Automatic}]},
         {"\<\"Image height\"\>", "15.72434195652884`"},
         {"\<\"Spherical aberration\"\>", "0.005767871299444782`"},
         {"\<\"Sagittal coma\"\>", "0.00035673156077279067`"},
         {"\<\"Astigmatism\"\>", 
          RowBox[{"-", "0.012872756368938846`"}]},
         {"\<\"Petzval radius\"\>", 
          RowBox[{"-", "600"}]},
         {"\<\"Sagittal curvature radius\"\>", 
          RowBox[{"-", "960"}]},
         {"\<\"Meridional curvature radius\"\>", "4800"},
         {"\<\"Mean curvature\"\>", "1920"},
         {"\<\"Focal length\"\>", 
          RowBox[{"-", "600.625619819724`"}]}
        },
        AutoDelete->False,
        BaseStyle->{"OutputValueBottom"},
        FrameStyle->GrayLevel[0.85],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1}}}],
       "Grid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.9],
  BaseStyle->"InputParameterTop"]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"WrightCamera", "[", 
   RowBox[{
   "f", ",", "Ni", ",", "thick", ",", "diam", ",", "\[CapitalDelta]", ",", 
    "\[Theta]", ",", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Wright's Camera\"\>", "Title",
       StripOnInput->False]},
     {
      StyleBox["\<\"Thu 1 Sep 2016 08:58:34\"\>", "Date",
       StripOnInput->False]},
     {
      StyleBox["\<\"WrightCamera\"\>", "Function",
       StripOnInput->False]},
     {
      InterpretationBox[
       StyleBox[
        GraphicsBox[{},
         BaselinePosition->Baseline,
         ImageSize->{10, 0}],
        CacheGraphics->False],
       Spacer[10]]},
     {
      StyleBox["\<\"Output values\"\>", "OutputValueTop",
       StripOnInput->False]},
     {
      TagBox[GridBox[{
         {"\<\"Conic constant of mirror\"\>", "0.6`"},
         {"\<\"Corrector equation\"\>", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "6.693409029342343`*^-6"}], " ", 
            SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"4.46253448825154`*^-10", " ", 
            SuperscriptBox["y", "4"]}]}]},
         {"\<\"Curvature radius of the second corrector surface\"\>", 
          RowBox[{"-", "74700.35042055801`"}]},
         {"\<\"Corrector sagitta:\"\>", 
          RowBox[{"-", "0.02509881131004733`"}]},
         {"\<\"Corrector plot\"\>", 
          GraphicsBox[{{{}, {}, 
             {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
              Opacity[1.], LineBox[CompressedData["
1:eJw12nk8VN/7APAKIRWRkuz7nlSSbQ5Z2hRm7syEhKwhKrKkQpaytEhmrj3Z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               "]]}}, {}, {}},
           AspectRatio->0.2,
           Axes->{True, True},
           AxesLabel->{None, None},
           AxesOrigin->{0, -0.025098811136086842`},
           DisplayFunction->Identity,
           Frame->{{False, False}, {False, False}},
           FrameLabel->{{None, None}, {None, None}},
           FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
           GridLines->{None, None},
           GridLinesStyle->Directive[
             GrayLevel[0.5, 0.4]],
           ImagePadding->All,
           
           Method->{
            "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
             AbsolutePointSize[6], "ScalingFunctions" -> None, 
             "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                 (
                 Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                  2][#]& )[
                  Part[#, 1]], 
                 (
                 Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                  2][#]& )[
                  Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                 (
                 Part[{{Identity, Identity}, {Identity, Identity}}, 1, 
                  2][#]& )[
                  Part[#, 1]], 
                 (
                 Part[{{Identity, Identity}, {Identity, Identity}}, 2, 
                  2][#]& )[
                  Part[#, 2]]}& )}},
           PlotRange->{All, All},
           PlotRangeClipping->True,
           PlotRangePadding->{{
              Scaled[0.02], 
              Scaled[0.02]}, {
              Scaled[0.05], 
              Scaled[0.05]}},
           Ticks->{Automatic, Automatic}]},
         {"\<\"Image height\"\>", "15.72434195652884`"},
         {"\<\"Spherical aberration\"\>", "0.005767871299444782`"},
         {"\<\"Sagittal coma\"\>", "0.00035673156077279067`"},
         {"\<\"Astigmatism\"\>", 
          RowBox[{"-", "0.012872756368938846`"}]},
         {"\<\"Petzval radius\"\>", 
          RowBox[{"-", "600"}]},
         {"\<\"Sagittal curvature radius\"\>", 
          RowBox[{"-", "960"}]},
         {"\<\"Meridional curvature radius\"\>", "4800"},
         {"\<\"Mean curvature\"\>", "1920"},
         {"\<\"Focal length\"\>", 
          RowBox[{"-", "600.625619819724`"}]}
        },
        AutoDelete->False,
        BaseStyle->{"OutputValueBottom"},
        FrameStyle->GrayLevel[0.85],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1}}}],
       "Grid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Left}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.9],
  BaseStyle->"InputParameterTop"]], "Text",
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"WrightCamera", "[", 
   RowBox[{
   "f", ",", "Ni", ",", "thick", ",", "diam", ",", "\[CapitalDelta]", ",", 
    "\[Theta]", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\<\"Input parameters\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"f1\"\>", ",", "600"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Ni\"\>", ",", "1.518722`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"thick\"\>", ",", "8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"diam\"\>", ",", "200"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"\[CapitalDelta]\"\>", ",", "750"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"\[Theta]\"\>", ",", "1.5`"}], "}"}]}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"\<\"Output values\"\>", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\<\"Conic constant of mirror\"\>", ",", "0.6`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Corrector equation\"\>", ",", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "6.693409029342343`*^-6"}], " ", 
           SuperscriptBox["y", "2"]}], "+", 
          RowBox[{"4.46253448825154`*^-10", " ", 
           SuperscriptBox["y", "4"]}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Curvature radius of the second corrector surface\"\>", 
         ",", 
         RowBox[{"-", "74700.35042055801`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Corrector sagitta:\"\>", ",", 
         RowBox[{"-", "0.02509881131004733`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Corrector plot\"\>", ",", 
         GraphicsBox[{{{}, {}, 
            {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
             Opacity[1.], LineBox[CompressedData["
1:eJw12nk8VN/7APAKIRWRkuz7nlSSbQ5Z2hRm7syEhKwhKrKkQpaytEhmrj3Z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              "]]}}, {}, {}},
          AspectRatio->0.2,
          Axes->{True, True},
          AxesLabel->{None, None},
          AxesOrigin->{0, -0.025098811136086842`},
          DisplayFunction->Identity,
          Frame->{{False, False}, {False, False}},
          FrameLabel->{{None, None}, {None, None}},
          FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
          GridLines->{None, None},
          GridLinesStyle->Directive[
            GrayLevel[0.5, 0.4]],
          ImagePadding->All,
          
          Method->{
           "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
            AbsolutePointSize[6], "ScalingFunctions" -> None, 
            "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
                (
                Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
                 Part[#, 1]], 
                (
                Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
                 Part[#, 2]]}& ), "CopiedValueFunction" -> ({
                (
                Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
                 Part[#, 1]], 
                (
                Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
                 Part[#, 2]]}& )}},
          PlotRange->{All, All},
          PlotRangeClipping->True,
          PlotRangePadding->{{
             Scaled[0.02], 
             Scaled[0.02]}, {
             Scaled[0.05], 
             Scaled[0.05]}},
          Ticks->{Automatic, Automatic}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Image height\"\>", ",", "15.72434195652884`"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Spherical aberration\"\>", ",", 
         "0.005767871299444782`"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Sagittal coma\"\>", ",", "0.00035673156077279067`"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Astigmatism\"\>", ",", 
         RowBox[{"-", "0.012872756368938846`"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Petzval radius\"\>", ",", 
         RowBox[{"-", "600"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Sagittal curvature radius\"\>", ",", 
         RowBox[{"-", "960"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Meridional curvature radius\"\>", ",", "4800"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Mean curvature\"\>", ",", "1920"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\<\"Focal length\"\>", ",", 
         RowBox[{"-", "600.625619819724`"}]}], "}"}]}], "}"}]}], "}"}]}], 
  "}"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"WrightCamera", "[", 
   RowBox[{
   "f", ",", "Ni", ",", "thick", ",", "diam", ",", "\[CapitalDelta]", ",", 
    "\[Theta]", ",", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6`", ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "6.693409029342343`*^-6"}], " ", 
     SuperscriptBox["y", "2"]}], "+", 
    RowBox[{"4.46253448825154`*^-10", " ", 
     SuperscriptBox["y", "4"]}]}], ",", 
   RowBox[{"-", "74700.35042055801`"}], ",", 
   RowBox[{"-", "0.02509881131004733`"}], ",", 
   GraphicsBox[{{{}, {}, 
      {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
       Opacity[1.], LineBox[CompressedData["
1:eJw12nk8VN/7APAKIRWRkuz7nlSSbQ5Z2hRm7syEhKwhKrKkQpaytEhmrj3Z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        "]]}}, {}, {}},
    AspectRatio->0.2,
    Axes->{True, True},
    AxesLabel->{None, None},
    AxesOrigin->{0, -0.025098811136086842`},
    DisplayFunction->Identity,
    Frame->{{False, False}, {False, False}},
    FrameLabel->{{None, None}, {None, None}},
    FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
    GridLines->{None, None},
    GridLinesStyle->Directive[
      GrayLevel[0.5, 0.4]],
    ImagePadding->All,
    Method->{
     "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
      AbsolutePointSize[6], "ScalingFunctions" -> None, 
      "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& ), "CopiedValueFunction" -> ({
          (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
           Part[#, 1]], 
          (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
           Part[#, 2]]}& )}},
    PlotRange->{All, All},
    PlotRangeClipping->True,
    PlotRangePadding->{{
       Scaled[0.02], 
       Scaled[0.02]}, {
       Scaled[0.05], 
       Scaled[0.05]}},
    Ticks->{Automatic, Automatic}], ",", "15.72434195652884`", ",", 
   "0.005767871299444782`", ",", "0.00035673156077279067`", ",", 
   RowBox[{"-", "0.012872756368938846`"}], ",", 
   RowBox[{"-", "600"}], ",", 
   RowBox[{"-", "960"}], ",", "4800", ",", "1920", ",", 
   RowBox[{"-", "600.625619819724`"}]}], "}"}]], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Troubleshooting and support", "Title"],

Cell[TextData[{
 "The whole software has been widely tested with many examples. However, it \
might happen that in some cases an error could arise. As a first attempt, \
save your work then close the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel (menu Evaluation\[Rule]Quit Kernel\[Rule]Local) and then load the \
package once again and run the same example. Sometimes, the problem could be \
due to an overlapping of variables value. Indeed, all packages use the same \
variable referring to theoretical parameters, so if you run many examples in \
the same working sessions and if they came from different packages, it could \
be that an old value of a parameter influences the current output.\nIf the \
problem still arise and you think it\[CloseCurlyQuote]s something due to a \
wrong behavior of the source code, please contact us at"
}], "Text"],

Cell[TextData[StyleBox["geometricopticsbook@gmail.com",
 FontWeight->"Bold"]], "Text",
 TextAlignment->Center],

Cell["Please, attach a notebook with all details of the problem.", "Text"]
}, Open  ]]
},
WindowSize->{1920, 992},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
PrintingCopies->1,
PrintingPageRange->{32000, 32000},
PrintingOptions->{"Magnification"->1.,
"PaperOrientation"->"Portrait",
"PaperSize"->{595.1999999999999, 841.68}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "GeometricOptics.nb"]]}, Visible -> False, 
  FrontEndVersion -> "11.0 for Microsoft Windows (64-bit) (July 28, 2016)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 59, 0, 71, "Title"],
Cell[641, 24, 29, 0, 71, "Title"],
Cell[673, 26, 459, 8, 94, "Text"],
Cell[1135, 36, 86, 2, 26, "Item"],
Cell[1224, 40, 90, 2, 26, "Item"],
Cell[1317, 44, 52, 0, 26, "Item"],
Cell[1372, 46, 63, 0, 26, "Item"],
Cell[1438, 48, 66, 0, 26, "Item"],
Cell[1507, 50, 48, 0, 26, "Item"],
Cell[1558, 52, 56, 0, 26, "Item"],
Cell[1617, 54, 99, 2, 26, "Item"],
Cell[1719, 58, 56, 0, 26, "Item"],
Cell[1778, 60, 48, 0, 26, "Item"],
Cell[1829, 62, 66, 0, 26, "Item"],
Cell[1898, 64, 46, 0, 26, "Item"],
Cell[1947, 66, 130, 3, 26, "Item"],
Cell[2080, 71, 137, 3, 26, "Item"],
Cell[2220, 76, 151, 3, 26, "Item"],
Cell[2374, 81, 33, 0, 26, "Item"],
Cell[2410, 83, 44, 0, 26, "Item"],
Cell[2457, 85, 300, 5, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2794, 95, 29, 0, 71, "Title"],
Cell[2826, 97, 252, 8, 46, "Text"],
Cell[CellGroupData[{
Cell[3103, 109, 38, 0, 43, "Chapter"],
Cell[3144, 111, 416, 7, 70, "Text"],
Cell[3563, 120, 163, 5, 46, "Text"],
Cell[3729, 127, 22133, 367, 361, "Text"],
Cell[25865, 496, 321, 5, 70, "Text"],
Cell[26189, 503, 149, 3, 46, "Text"],
Cell[26341, 508, 168, 4, 26, "Item"],
Cell[26512, 514, 163, 4, 26, "Item"],
Cell[26678, 520, 137, 3, 46, "Text"],
Cell[CellGroupData[{
Cell[26840, 527, 189, 5, 32, "Input"],
Cell[27032, 534, 131, 1, 30, "Output"]
}, Open  ]],
Cell[27178, 538, 67, 0, 46, "Text"],
Cell[27248, 540, 190, 5, 32, "Input"],
Cell[27441, 547, 112, 3, 46, "Text"],
Cell[CellGroupData[{
Cell[27578, 554, 185, 5, 32, "Input"],
Cell[27766, 561, 104, 1, 30, "Output"]
}, Open  ]],
Cell[27885, 565, 67, 0, 46, "Text"],
Cell[27955, 567, 186, 5, 32, "Input"],
Cell[28144, 574, 193, 4, 46, "Text"],
Cell[28340, 580, 36464, 602, 235, "Text"],
Cell[64807, 1184, 107, 3, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[64951, 1192, 38, 0, 43, "Chapter"],
Cell[64992, 1194, 128, 3, 46, "Text"],
Cell[65123, 1199, 49, 0, 46, "Text"],
Cell[65175, 1201, 108, 3, 46, "Text"],
Cell[65286, 1206, 130, 3, 46, "Text"],
Cell[65419, 1211, 48, 0, 46, "Text"],
Cell[65470, 1213, 172, 3, 46, "Text"],
Cell[65645, 1218, 189, 5, 32, "Input"],
Cell[65837, 1225, 185, 5, 32, "Input"],
Cell[66025, 1232, 118, 3, 46, "Text"],
Cell[66146, 1237, 190, 5, 32, "Input"],
Cell[66339, 1244, 186, 5, 32, "Input"],
Cell[66528, 1251, 162, 3, 46, "Text"],
Cell[66693, 1256, 36262, 598, 358, "Input"],
Cell[102958, 1856, 260, 7, 46, "Text"],
Cell[103221, 1865, 54, 0, 46, "Text"],
Cell[103278, 1867, 156, 3, 46, "Text"],
Cell[103437, 1872, 263, 7, 32, "Input"],
Cell[103703, 1881, 254, 7, 32, "Input"],
Cell[103960, 1890, 250, 4, 46, "Text"],
Cell[104213, 1896, 124, 3, 46, "Text"],
Cell[104340, 1901, 260, 7, 46, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[104649, 1914, 60, 0, 71, "Title"],
Cell[104712, 1916, 347, 7, 70, "Text"],
Cell[105062, 1925, 16214, 270, 123, "Text"],
Cell[121279, 2197, 61, 0, 46, "Text"],
Cell[121343, 2199, 24137, 403, 99, "Text"],
Cell[145483, 2604, 30078, 505, 127, "Text"],
Cell[175564, 3111, 16700, 278, 459, "Text"],
Cell[192267, 3391, 56, 0, 46, "Text"],
Cell[192326, 3393, 2738, 51, 123, "Text"],
Cell[195067, 3446, 2847, 53, 99, "Text"],
Cell[197917, 3501, 443, 7, 70, "Text"],
Cell[198363, 3510, 2189, 42, 99, "Text"],
Cell[200555, 3554, 16241, 271, 459, "Text"],
Cell[216799, 3827, 371, 6, 70, "Text"],
Cell[217173, 3835, 86199, 1417, 951, "Text"],
Cell[303375, 5254, 166, 3, 46, "Text"],
Cell[303544, 5259, 95443, 1569, 951, "Text"],
Cell[398990, 6830, 2210, 42, 123, "Text"],
Cell[401203, 6874, 64688, 1065, 692, "Text"],
Cell[465894, 7941, 2396, 45, 99, "Text"],
Cell[468293, 7988, 355, 6, 70, "Text"],
Cell[468651, 7996, 1694, 33, 99, "Text"],
Cell[470348, 8031, 34615, 572, 351, "Text"],
Cell[504966, 8605, 191, 4, 46, "Text"],
Cell[505160, 8611, 2061, 40, 123, "Text"],
Cell[507224, 8653, 36476, 602, 288, "Text"],
Cell[543703, 9257, 488, 10, 70, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[544228, 9272, 83, 1, 71, "Title"],
Cell[544314, 9275, 574, 9, 94, "Text"],
Cell[544891, 9286, 45, 0, 46, "Text"],
Cell[544939, 9288, 433, 15, 143, "Input"],
Cell[545375, 9305, 113, 3, 46, "Text"],
Cell[545491, 9310, 164, 4, 32, "Input"],
Cell[545658, 9316, 171, 3, 46, "Text"],
Cell[545832, 9321, 72350, 1190, 973, "Input"],
Cell[618185, 10513, 124, 3, 46, "Text"],
Cell[618312, 10518, 115, 4, 46, "Text"],
Cell[618430, 10524, 126, 3, 26, "Item"],
Cell[618559, 10529, 99, 2, 26, "Item"],
Cell[618661, 10533, 131, 3, 26, "Item"],
Cell[618795, 10538, 90, 2, 26, "Item"],
Cell[618888, 10542, 117, 4, 46, "Text"],
Cell[619008, 10548, 70, 0, 26, "Item"],
Cell[619081, 10550, 52, 0, 26, "Item"],
Cell[619136, 10552, 89, 2, 46, "Text"],
Cell[619228, 10556, 484, 12, 55, "Input"],
Cell[619715, 10570, 17052, 333, 727, "Text"],
Cell[636770, 10905, 511, 12, 55, "Input"],
Cell[637284, 10919, 15756, 301, 561, "Text"],
Cell[CellGroupData[{
Cell[653065, 11224, 666, 15, 55, "Input"],
Cell[653734, 11241, 15696, 296, 162, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[669467, 11542, 780, 19, 55, "Input"],
Cell[670250, 11563, 13391, 237, 70, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[683690, 11806, 44, 0, 71, "Title"],
Cell[683737, 11808, 867, 14, 118, "Text"],
Cell[684607, 11824, 110, 2, 46, "Text"],
Cell[684720, 11828, 74, 0, 46, "Text"]
}, Open  ]]
}
]
*)

